/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.skyarena.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class BossBarHideZones {
    private static final Map<ResourceKey<Level>, Map<BlockPos, Integer>> BOSS_BAR_HIDE_ZONES = new HashMap<ResourceKey<Level>, Map<BlockPos, Integer>>();

    private BossBarHideZones() {
    }

    public static void add(Level level, BlockPos altarPos, int radius) {
        BOSS_BAR_HIDE_ZONES.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new HashMap()).put(altarPos, radius);
    }

    public static void remove(Level level, BlockPos altarPos) {
        Map<BlockPos, Integer> perDim = BOSS_BAR_HIDE_ZONES.get(level.m_46472_());
        if (perDim == null) {
            return;
        }
        perDim.remove(altarPos);
        if (perDim.isEmpty()) {
            BOSS_BAR_HIDE_ZONES.remove(level.m_46472_());
        }
    }

    public static boolean isInZone(Level level, BlockPos pos) {
        Map<BlockPos, Integer> perDim = BOSS_BAR_HIDE_ZONES.get(level.m_46472_());
        if (perDim == null || perDim.isEmpty()) {
            return false;
        }
        for (Map.Entry<BlockPos, Integer> e : perDim.entrySet()) {
            if (!e.getKey().m_123314_((Vec3i)pos, (double)e.getValue().intValue())) continue;
            return true;
        }
        return false;
    }
}

