/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.inventory;

import fuzs.illagerinvasion.init.ModRegistry;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;

public class ImbuingMenu
extends AbstractContainerMenu {
    private final Container input;
    private final ResultContainer output = new ResultContainer();
    private final ContainerLevelAccess access;
    public final DataSlot invalidState;

    public ImbuingMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public ImbuingMenu(int containerId, Inventory inventory, ContainerLevelAccess access) {
        super((MenuType)ModRegistry.IMBUING_MENU_TYPE.get(), containerId);
        int i;
        this.access = access;
        this.invalidState = this.m_38895_(DataSlot.m_39401_());
        this.input = new SimpleContainer(3){

            public void m_6596_() {
                super.m_6596_();
                ImbuingMenu.this.m_6199_((Container)this);
            }
        };
        this.m_38897_(new Slot(this.input, 0, 26, 54){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42690_);
            }
        });
        this.m_38897_(new Slot(this.input, 1, 80, 54){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41793_();
            }
        });
        this.m_38897_(new Slot(this.input, 2, 134, 54){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)ModRegistry.HALLOWED_GEM_ITEM.get());
            }
        });
        this.m_38897_(new Slot((Container)this.output, 3, 80, 14){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player playerEntity) {
                return true;
            }

            public void m_142406_(Player playerEntity, ItemStack itemStack) {
                ImbuingMenu.this.input.m_6836_(0, ItemStack.f_41583_);
                ImbuingMenu.this.input.m_6836_(1, ItemStack.f_41583_);
                ItemStack stack = ImbuingMenu.this.input.m_8020_(2);
                stack.m_41774_(1);
                ImbuingMenu.this.input.m_6836_(2, stack);
                ImbuingMenu.this.invalidState.m_6422_(InvalidImbuingState.ALL_GOOD.ordinal());
                playerEntity.m_5496_((SoundEvent)ModRegistry.SORCERER_COMPLETE_CAST_SOUND_EVENT.get(), 1.0f, 1.0f);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
    }

    public void m_6199_(Container inventory) {
        if (inventory == this.input) {
            this.updateResult();
        }
        super.m_6199_(inventory);
    }

    public boolean m_6875_(Player player) {
        return ImbuingMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModRegistry.IMBUING_TABLE_BLOCK.get()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateResult() {
        block5: {
            block6: {
                Enchantment enchantment;
                Map enchantments;
                ItemStack imbuingResult;
                ItemStack imbuingItem;
                block8: {
                    block7: {
                        imbuingItem = this.input.m_8020_(1);
                        ItemStack bookStack = this.input.m_8020_(0);
                        ItemStack gem = this.input.m_8020_(2);
                        imbuingResult = imbuingItem.m_41777_();
                        if (bookStack.m_41619_() || gem.m_41619_() || imbuingItem.m_41619_()) break block6;
                        enchantments = EnchantmentHelper.m_44831_((ItemStack)bookStack);
                        if (enchantments.size() == 1) break block7;
                        this.invalidState.m_6422_(InvalidImbuingState.TOO_MANY_ENCHANTMENTS.ordinal());
                        break block5;
                    }
                    enchantment = (Enchantment)enchantments.keySet().iterator().next();
                    if (BuiltInRegistries.f_256876_.m_263177_((Object)enchantment).m_203656_(ModRegistry.IMBUING_ENCHANTMENT_TAG)) break block8;
                    this.invalidState.m_6422_(InvalidImbuingState.INVALID_ENCHANTMENT.ordinal());
                    break block5;
                }
                if (enchantments.getOrDefault(enchantment, 0).intValue() != enchantment.m_6586_()) {
                    this.invalidState.m_6422_(InvalidImbuingState.NOT_AT_MAX_LEVEL.ordinal());
                    break block5;
                } else if (!enchantment.m_6081_(imbuingItem)) {
                    this.invalidState.m_6422_(InvalidImbuingState.INVALID_ITEM.ordinal());
                    break block5;
                } else {
                    Map imbueMap = EnchantmentHelper.m_44831_((ItemStack)imbuingItem);
                    if (imbueMap.getOrDefault(enchantment, 0).intValue() == enchantment.m_6586_()) {
                        int imbueLevel = (Integer)enchantments.get(enchantment) + 1;
                        imbueMap.put(enchantment, imbueLevel);
                        EnchantmentHelper.m_44865_((Map)imbueMap, (ItemStack)imbuingResult);
                        this.output.m_6836_(0, imbuingResult);
                        this.invalidState.m_6422_(InvalidImbuingState.ALL_GOOD.ordinal());
                        return;
                    }
                    this.invalidState.m_6422_(InvalidImbuingState.AT_WRONG_LEVEL.ordinal());
                }
                break block5;
            }
            this.invalidState.m_6422_(InvalidImbuingState.ALL_GOOD.ordinal());
        }
        this.output.m_6836_(0, ItemStack.f_41583_);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            if (index == 3) {
                if (!this.m_38903_(itemStack2, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (index == 0 || index == 1 || index == 2 ? !this.m_38903_(itemStack2, 3, 39, false) : index >= 3 && index < 39 && !this.m_38903_(itemStack2, 0, 3, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(player, this.input));
    }

    public static enum InvalidImbuingState {
        ALL_GOOD(CommonComponents.f_237098_),
        TOO_MANY_ENCHANTMENTS((Component)Component.m_237115_((String)"container.imbue.tooManyEnchantments")),
        NOT_AT_MAX_LEVEL((Component)Component.m_237115_((String)"container.imbue.notAtMaxLevel")),
        AT_WRONG_LEVEL((Component)Component.m_237115_((String)"container.imbue.atWrongLevel")),
        INVALID_ENCHANTMENT((Component)Component.m_237115_((String)"container.imbue.invalidEnchantment")),
        INVALID_ITEM((Component)Component.m_237115_((String)"container.imbue.invalidItem"));

        public final Component component;

        private InvalidImbuingState(Component component) {
            this.component = component;
        }

        public String getTranslationKey() {
            return ((TranslatableContents)this.component.m_214077_()).m_237508_();
        }
    }
}

