/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.world.entity.projectile.SkullBolt;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Necromancer
extends SpellcasterIllager
implements PowerableMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.m_135353_(Necromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int conjureSkullCooldown;

    public Necromancer(EntityType<? extends Necromancer> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetOrWololoTarget());
        this.f_21345_.m_25352_(4, (Goal)new ConjureSkullGoal());
        this.f_21345_.m_25352_(3, (Goal)new SummonUndeadGoal());
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_SHIELDED, (Object)false);
    }

    public boolean getShieldedState() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SHIELDED);
    }

    public void setShieldedState(boolean isShielded) {
        this.f_19804_.m_135381_(DATA_IS_SHIELDED, (Object)isShielded);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    protected void m_8024_() {
        super.m_8024_();
        --this.conjureSkullCooldown;
        List mobs = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(10.0), mob -> mob.m_6336_() == MobType.f_21641_);
        if (!mobs.isEmpty()) {
            mobs.forEach(this::doUndeadLinkLogic);
            if (this.f_19797_ % 10 == 0) {
                mobs.forEach(this::doUndeadLinkParticle);
            }
        }
        if (this.f_19797_ % 20 == 0) {
            this.setShieldedState(!mobs.isEmpty());
        }
        if (this.m_5448_() != null) {
            mobs = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(30.0), mob -> mob.m_6336_() == MobType.f_21641_);
            mobs.forEach(this::setUndeadTarget);
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_6336_() != MobType.f_21641_ && super.m_6779_(target);
    }

    public void doUndeadLinkLogic(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 10, 0));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10, 0));
        entity.m_20095_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6710_(this.m_5448_());
        }
    }

    public void setUndeadTarget(LivingEntity entity) {
        if (this.m_5448_() != null && entity instanceof Mob) {
            ((Mob)entity).m_6710_(this.m_5448_());
        }
    }

    public void doUndeadLinkParticle(LivingEntity entity) {
        if (!this.m_9236_().f_46443_) {
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)ModRegistry.NECROMANCER_BUFF_PARTICLE_TYPE.get()), x, y + 1.0, z, 1, 0.4, 0.5, 0.4, 0.015);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)ModRegistry.NECROMANCER_BUFF_PARTICLE_TYPE.get()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, 0.4, 0.5, 0.4, 0.015);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, this.getShieldedState() ? amount / 2.0f : amount);
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.m_7307_((Entity)((Vex)other).m_19749_());
        }
        return other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_ && this.m_5647_() == null && other.m_5647_() == null;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12050_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12051_;
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    public void m_7895_(int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean m_7090_() {
        return this.getShieldedState();
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Necromancer.this);
        }

        public void m_8037_() {
            if (Necromancer.this.m_5448_() != null) {
                Necromancer.this.m_21563_().m_24960_((Entity)Necromancer.this.m_5448_(), (float)Necromancer.this.m_8085_(), (float)Necromancer.this.m_8132_());
            }
        }
    }

    public class ConjureSkullGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureSkullGoal() {
            super((SpellcasterIllager)Necromancer.this);
        }

        public boolean m_8036_() {
            if (Necromancer.this.m_5448_() == null) {
                return false;
            }
            if (Necromancer.this.conjureSkullCooldown > 0) {
                return false;
            }
            if (Necromancer.this.conjureSkullCooldown <= 0) {
                return true;
            }
            return true;
        }

        public void m_8041_() {
            super.m_8041_();
        }

        private void shootSkullAt(LivingEntity target) {
            this.shootSkullAt(target.m_20185_(), target.m_20186_() + (double)target.m_20192_() * 0.5, target.m_20189_());
        }

        private void shootSkullAt(double targetX, double targetY, double targetZ) {
            double d = Necromancer.this.m_20185_();
            double e = Necromancer.this.m_20186_() + 2.5;
            double f = Necromancer.this.m_20189_();
            double g = targetX - d;
            double h = targetY - e;
            double i = targetZ - f;
            SkullBolt skullbolt = new SkullBolt(Necromancer.this.m_9236_(), (LivingEntity)Necromancer.this, g, h, i);
            skullbolt.m_5602_((Entity)Necromancer.this);
            skullbolt.m_20343_(d, e, f);
            Necromancer.this.m_9236_().m_7967_((Entity)skullbolt);
        }

        protected void m_8130_() {
            this.shootSkullAt(Necromancer.this.m_5448_());
            if (!Necromancer.this.m_9236_().f_46443_) {
                double x = Necromancer.this.m_20185_();
                double y = Necromancer.this.m_20186_() + 2.5;
                double z = Necromancer.this.m_20189_();
                ((ServerLevel)Necromancer.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 40, 0.4, 0.4, 0.4, 0.15);
            }
            Necromancer.this.conjureSkullCooldown = 100;
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 140;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_11867_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return (SpellcasterIllager.IllagerSpell)ModRegistry.CONJURE_SKULL_BOLT_ILLAGER_SPELL;
        }
    }

    class SummonUndeadGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions closeVexPredicate;
        private int spellcount;

        SummonUndeadGoal() {
            super((SpellcasterIllager)Necromancer.this);
            this.closeVexPredicate = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            if (this.spellcount >= 4) {
                return false;
            }
            int i = Necromancer.this.m_9236_().m_45971_(Zombie.class, this.closeVexPredicate, (LivingEntity)Necromancer.this, Necromancer.this.m_20191_().m_82400_(16.0)).size();
            return Necromancer.this.f_19796_.m_188503_(5) + 1 > i;
        }

        protected int m_8089_() {
            return 100;
        }

        protected int m_8067_() {
            return 340;
        }

        protected void m_8130_() {
            int spawnAmount = Necromancer.this.m_9236_().m_46462_() ? 4 : 2;
            ServerLevel serverWorld = (ServerLevel)Necromancer.this.m_9236_();
            for (int i = 0; i < spawnAmount; ++i) {
                BlockPos blockPos = Necromancer.this.m_20183_().m_7918_(-2 + Necromancer.this.f_19796_.m_188503_(5), 1, -2 + Necromancer.this.f_19796_.m_188503_(5));
                Zombie zombieEntity = (Zombie)EntityType.f_20501_.m_20615_(Necromancer.this.m_9236_());
                zombieEntity.m_20035_(blockPos, 0.0f, 0.0f);
                zombieEntity.m_6518_((ServerLevelAccessor)serverWorld, Necromancer.this.m_9236_().m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                serverWorld.m_47205_((Entity)zombieEntity);
            }
            BlockPos blockPos = Necromancer.this.m_20183_().m_7918_(-2 + Necromancer.this.f_19796_.m_188503_(5), 1, -2 + Necromancer.this.f_19796_.m_188503_(5));
            Skeleton skeletonEntity = (Skeleton)EntityType.f_20524_.m_20615_(Necromancer.this.m_9236_());
            skeletonEntity.m_20035_(blockPos, 0.0f, 0.0f);
            skeletonEntity.m_6518_((ServerLevelAccessor)serverWorld, Necromancer.this.m_9236_().m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
            serverWorld.m_47205_((Entity)skeletonEntity);
            ++this.spellcount;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.NECROMANCER_SUMMON_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return (SpellcasterIllager.IllagerSpell)ModRegistry.NECRO_RAISE_ILLAGER_SPELL;
        }
    }
}

