/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class InvokerFangs
extends Entity {
    private int warmup;
    private boolean startedAttack;
    private int ticksLeft = 22;
    private boolean playingAnimation;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUuid;

    public InvokerFangs(EntityType<? extends InvokerFangs> entityType, Level world) {
        super(entityType, world);
    }

    public InvokerFangs(Level world, double x, double y, double z, float yaw, int warmup, LivingEntity owner) {
        this((EntityType<? extends InvokerFangs>)((EntityType)ModRegistry.INVOKER_FANGS_ENTITY_TYPE.get()), world);
        this.warmup = warmup;
        this.setOwner(owner);
        this.m_146922_(yaw * 57.295776f);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUuid)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUuid = owner == null ? null : owner.m_20148_();
    }

    protected void m_7378_(CompoundTag nbt) {
        this.warmup = nbt.m_128451_("Warmup");
        if (nbt.m_128403_("Owner")) {
            this.ownerUuid = nbt.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Warmup", this.warmup);
        if (this.ownerUuid != null) {
            nbt.m_128362_("Owner", this.ownerUuid);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.playingAnimation) {
                --this.ticksLeft;
                if (this.ticksLeft == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double e = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        double f = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double g = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        double h = 0.3 + this.f_19796_.m_188500_() * 0.3;
                        double j = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, d, e + 1.0, f, g, h, j);
                    }
                }
            }
        } else if (--this.warmup < 0) {
            if (this.warmup == -8) {
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2));
                for (LivingEntity livingEntity : list) {
                    this.damage(livingEntity);
                }
            }
            if (!this.startedAttack) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.startedAttack = true;
            }
            if (--this.ticksLeft < 0) {
                this.m_146870_();
            }
        }
    }

    private void damage(LivingEntity target) {
        LivingEntity livingEntity = this.getOwner();
        if (!target.m_6084_() || target.m_20147_() || target == livingEntity) {
            return;
        }
        if (livingEntity == null) {
            target.m_6469_(this.m_269291_().m_269425_(), 10.0f);
            target.m_5997_(0.0, (double)1.7f, 0.0);
        } else {
            if (livingEntity.m_7307_((Entity)target)) {
                return;
            }
            target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingEntity), 10.0f);
            this.knockBack(target);
        }
    }

    public void m_7822_(byte status) {
        super.m_7822_(status);
        if (status == 4) {
            this.playingAnimation = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModRegistry.INVOKER_FANGS_SOUND_EVENT.get(), this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    private void knockBack(LivingEntity entity) {
        entity.m_5997_(0.0, 0.6, 0.0);
    }

    public float getAnimationProgress(float tickDelta) {
        if (!this.playingAnimation) {
            return 0.0f;
        }
        int i = this.ticksLeft - 2;
        if (i <= 0) {
            return 1.0f;
        }
        return 1.0f - ((float)i - tickDelta) / 20.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

