/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import com.google.common.collect.Maps;
import fuzs.illagerinvasion.init.ModRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Inquisitor
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> STUNNED = SynchedEntityData.m_135353_(Inquisitor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FINAL_ROAR = SynchedEntityData.m_135353_(Inquisitor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean finalRoar;
    public int stunTick = 40;
    public boolean isStunned;
    public int blockedCount;

    public Inquisitor(EntityType<? extends Inquisitor> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 25;
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void m_8024_() {
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            boolean bl = ((ServerLevel)this.m_9236_()).m_8843_(this.m_20183_());
            ((GroundPathNavigation)this.m_21573_()).m_26477_(bl);
        }
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.f_19862_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean bl = false;
            AABB box = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)box.f_82288_), (int)Mth.m_14107_((double)box.f_82289_), (int)Mth.m_14107_((double)box.f_82290_), (int)Mth.m_14107_((double)box.f_82291_), (int)Mth.m_14107_((double)box.f_82292_), (int)Mth.m_14107_((double)box.f_82293_))) {
                Block block = this.m_9236_().m_8055_(blockPos).m_60734_();
                if (!(block instanceof LeavesBlock) && !(block instanceof DoorBlock) && !(block instanceof WebBlock)) continue;
                boolean bl2 = bl = this.m_9236_().m_46953_(blockPos, true, (Entity)this) || bl;
                if (!(block instanceof DoorBlock)) continue;
                this.m_5496_(SoundEvents.f_12601_, 1.0f, 1.0f);
            }
        }
        super.m_8107_();
    }

    public boolean m_142582_(Entity entity) {
        return !this.getStunnedState() && super.m_142582_(entity);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getStunnedState();
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128379_("Stunned", this.isStunned);
        nbt.m_128379_("FinalRoar", this.finalRoar);
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setStunnedState(nbt.m_128471_("Stunned"));
        this.setFinalRoarState(nbt.m_128471_("FinalRoar"));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STUNNED, (Object)false);
        this.f_19804_.m_135372_(FINAL_ROAR, (Object)false);
        super.m_8097_();
    }

    public boolean getStunnedState() {
        return (Boolean)this.f_19804_.m_135370_(STUNNED);
    }

    public void setStunnedState(boolean isStunned) {
        this.f_19804_.m_135381_(STUNNED, (Object)isStunned);
    }

    public boolean getFinalRoarState() {
        return (Boolean)this.f_19804_.m_135370_(FINAL_ROAR);
    }

    public void setFinalRoarState(boolean hasdoneRoar) {
        this.f_19804_.m_135381_(FINAL_ROAR, (Object)hasdoneRoar);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_37888_()) {
            return AbstractIllager.IllagerArmPose.CELEBRATING;
        }
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    protected PathNavigation m_6037_(Level world) {
        return new Navigation((Mob)this, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        if (this.getStunnedState()) {
            --this.stunTick;
            if (this.stunTick <= 0) {
                this.setStunnedState(false);
                this.stunTick = 40;
            }
        }
    }

    private List<LivingEntity> getTargets() {
        return this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(8.0), entity -> !(entity instanceof Monster));
    }

    private void knockBack(Entity entity) {
        double d = entity.m_20185_() - this.m_20185_();
        double e = entity.m_20189_() - this.m_20189_();
        double f = Math.max(d * d + e * e, 0.001);
        entity.m_5997_(d / f * 0.6, 0.4, e / f * 0.6);
    }

    protected void m_6731_(LivingEntity target) {
        this.knockBack((Entity)target);
        target.f_19864_ = true;
        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData entityData2 = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_213945_(world.m_213780_(), difficulty);
        this.m_213946_(world.m_213780_(), difficulty);
        return entityData2;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }

    public boolean m_7307_(Entity other) {
        return super.m_7307_(other) || other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_ && this.m_5647_() == null && other.m_5647_() == null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        boolean hasShield = this.m_21206_().m_150930_(Items.f_42740_);
        if (this.m_5912_()) {
            if (attacker instanceof LivingEntity) {
                ItemStack item = ((LivingEntity)attacker).m_21205_();
                ItemStack basherItem = this.m_21206_();
                boolean isShield = basherItem.m_150930_(Items.f_42740_);
                if ((item.m_204117_(ItemTags.f_271207_) || attacker instanceof IronGolem || this.blockedCount >= 4) && isShield) {
                    this.m_5496_(SoundEvents.f_12347_, 1.0f, 1.0f);
                    this.setStunnedState(true);
                    if (this.m_9236_() instanceof ServerLevel) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, basherItem), this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), 30, 0.3, 0.2, 0.3, 0.003);
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 30, 0.3, 0.3, 0.3, 0.1);
                        this.m_5496_(SoundEvents.f_12363_, 1.0f, 1.0f);
                        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    this.getTargets().forEach(this::m_6731_);
                    return super.m_6469_(source, amount);
                }
            }
            if (source.m_7640_() instanceof AbstractArrow && hasShield) {
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
                ++this.blockedCount;
                return false;
            }
            if (source.m_7640_() instanceof LivingEntity && hasShield) {
                ++this.blockedCount;
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ILLAGER_BRUTE_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ILLAGER_BRUTE_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.ILLAGER_BRUTE_HURT_SOUND_EVENT.get();
    }

    public void m_7895_(int wave, boolean unused) {
        boolean bl2;
        boolean bl;
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42425_);
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42740_);
        Raid raid = this.m_37885_();
        int i = 1;
        if (wave > raid.m_37724_(Difficulty.NORMAL)) {
            i = 2;
        }
        if (bl = (bl2 = this.f_19796_.m_188501_() <= raid.m_37783_())) {
            HashMap map = Maps.newHashMap();
            map.put(Enchantments.f_44977_, i);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
        this.m_8061_(EquipmentSlot.OFFHAND, itemstack1);
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(Inquisitor vindicator) {
            super((PathfinderMob)vindicator, 1.0, false);
        }

        protected double m_6639_(LivingEntity entity) {
            if (this.f_25540_.m_20202_() instanceof Ravager) {
                float f = this.f_25540_.m_20202_().m_20205_() - 0.1f;
                return f * 2.0f * (f * 2.0f) + entity.m_20205_();
            }
            return super.m_6639_(entity);
        }
    }

    static class Navigation
    extends GroundPathNavigation {
        public Navigation(Mob mobEntity, Level world) {
            super(mobEntity, world);
        }

        protected PathFinder m_5532_(int range) {
            this.f_26508_ = new NodeEvaluator();
            return new PathFinder(this.f_26508_, range);
        }
    }

    static class NodeEvaluator
    extends WalkNodeEvaluator {
        NodeEvaluator() {
        }

        protected BlockPathTypes m_264405_(BlockGetter blockGetter, BlockPos blockPos, BlockPathTypes blockPathTypes) {
            if (blockPathTypes == BlockPathTypes.LEAVES) {
                return BlockPathTypes.OPEN;
            }
            return super.m_264405_(blockGetter, blockPos, blockPathTypes);
        }
    }
}

