/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.client.model.SpriteReplacementModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DrawerModelStore {
    public static final FrameMatSet FramedStandardDrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_DRAWERS_SIDE).trimPart(DynamicPart.FRAMED_DRAWERS_TRIM).frontPart(DynamicPart.FRAMED_DRAWERS_FRONT).shadeFrontPart(DynamicPart.FRAMED_DRAWERS_SHADING);
    public static final FrameMatSet FramedComp2DrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_COMP2_SIDE).trimPart(DynamicPart.FRAMED_COMP2_TRIM).frontPart(DynamicPart.FRAMED_COMP2_FRONT).shadeFrontPart(DynamicPart.FRAMED_COMP2_SHADING);
    public static final FrameMatSet FramedComp3DrawerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_COMP3_SIDE).trimPart(DynamicPart.FRAMED_COMP3_TRIM).frontPart(DynamicPart.FRAMED_COMP3_FRONT).shadeFrontPart(DynamicPart.FRAMED_COMP3_SHADING);
    public static final FrameMatSet FramedControllerMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_CONTROLLER_SIDE).trimPart(DynamicPart.FRAMED_CONTROLLER_TRIM).frontPart(DynamicPart.FRAMED_CONTROLLER_FRONT).shadeFrontPart(DynamicPart.FRAMED_CONTROLLER_SHADING);
    public static final FrameMatSet FramedControllerIOMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_CONTROLLER_IO_SIDE).trimPart(DynamicPart.FRAMED_CONTROLLER_IO_TRIM).shadeFrontPart(DynamicPart.FRAMED_CONTROLLER_IO_SHADING);
    public static final FrameMatSet FramedTrimMaterials = new FrameMatSet().sidePart(DynamicPart.FRAMED_TRIM_SIDE).trimPart(DynamicPart.FRAMED_TRIM_TRIM);
    private static final Map<String, BakedModel> modelStore = new HashMap<String, BakedModel>();
    private static final Map<String, ModelResourceLocation> locationStore = new HashMap<String, ModelResourceLocation>();
    public static final DecorationSet INSTANCE = new DecorationSet();
    private static final DynamicPart[] missingSlots1 = new DynamicPart[]{DynamicPart.MISSING_1};
    private static final DynamicPart[] missingSlots2 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2};
    private static final DynamicPart[] missingSlots4 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2, DynamicPart.MISSING_3, DynamicPart.MISSING_4};
    public static final DynamicPart[][] missingSlots = new DynamicPart[][]{missingSlots1, missingSlots2, new DynamicPart[0], missingSlots4};

    static ModelResourceLocation addLocation(ModelResourceLocation loc) {
        locationStore.put(loc.toString(), loc);
        modelStore.put(loc.toString(), null);
        return loc;
    }

    static String getVariant() {
        return "";
    }

    static String getVariant(Direction dir) {
        return "facing=" + dir.m_122433_();
    }

    static String getVariant(Direction dir, boolean half) {
        return "facing=" + dir.m_122433_() + ",half=" + half;
    }

    static String getVariant(Direction dir, boolean half, int slots) {
        return "facing=" + dir.m_122433_() + ",half=" + half + ",slots=" + slots;
    }

    static String getVariant(Direction dir, boolean half, EnumCompDrawer slots) {
        return "facing=" + dir.m_122433_() + ",half=" + half + ",slots=" + slots;
    }

    static String getSlotVariant(Direction dir, boolean half, int slot) {
        return "facing=" + dir.m_122433_() + ",half=" + half + ",slot=" + slot;
    }

    static String getVariant(DynamicPart part) {
        return "part=" + part.getName();
    }

    static String getVariant(DynamicPart part, Direction dir) {
        return "part=" + part.getName() + ",facing=" + dir.m_122433_();
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half) {
        return "part=" + part.getName() + ",facing=" + dir.m_122433_() + ",half=" + half;
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half, int slots) {
        return "part=" + part.getName() + ",facing=" + dir.m_122433_() + ",half=" + half + ",slots=" + slots;
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half, EnumCompDrawer slots) {
        return "part=" + part.getName() + ",facing=" + dir.m_122433_() + ",half=" + half + ",slots=" + slots;
    }

    static String getSlotVariant(DynamicPart part, Direction dir, boolean half, int slot) {
        return "part=" + part.getName() + ",facing=" + dir.m_122433_() + ",half=" + half + ",slot=" + slot;
    }

    public static Stream<ModelResourceLocation> getModelLocations() {
        return locationStore.values().stream();
    }

    public static void tryAddModel(ModelResourceLocation loc, BakedModel model) {
        if (loc == null) {
            return;
        }
        String key = loc.toString();
        if (modelStore.containsKey(key)) {
            modelStore.put(key, model);
        }
    }

    public static BakedModel getModel(ModelResourceLocation loc) {
        if (loc == null) {
            return null;
        }
        BakedModel storedModel = modelStore.get(loc.toString());
        if (storedModel == null) {
            return Minecraft.m_91087_().m_91304_().m_119422_(loc);
        }
        return storedModel;
    }

    public static BakedModel getModel(String variant) {
        return DrawerModelStore.getModel(DrawerModelStore.INSTANCE.overlays.getOrDefault(variant, null));
    }

    public static BakedModel getModel(DynamicPart part) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part));
    }

    public static BakedModel getModel(DynamicPart part, Direction dir) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir));
    }

    public static BakedModel getModel(DynamicPart part, Direction dir, boolean half) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half));
    }

    public static BakedModel getModel(DynamicPart part, Direction dir, boolean half, int slots) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half, slots));
    }

    public static BakedModel getModel(DynamicPart part, Direction dir, boolean half, EnumCompDrawer slots) {
        return DrawerModelStore.getModel(DrawerModelStore.getVariant(part, dir, half, slots));
    }

    public static BakedModel getReplacementModel(ModelResourceLocation loc, ModelResourceLocation replaceLoc) {
        String key = loc.toString() + ":" + replaceLoc.toString();
        if (modelStore.containsKey(key)) {
            return modelStore.get(key);
        }
        BakedModel model = DrawerModelStore.getModel(loc);
        BakedModel replacementModel = DrawerModelStore.getModel(replaceLoc);
        if (replacementModel == null) {
            return model;
        }
        SpriteReplacementModel merged = new SpriteReplacementModel(model, replacementModel);
        modelStore.put(key, merged);
        return merged;
    }

    public static BakedModel getReplacementModel(String variant, String replaceVariant) {
        return DrawerModelStore.getReplacementModel(DrawerModelStore.INSTANCE.overlays.getOrDefault(variant, null), DrawerModelStore.INSTANCE.overlays.getOrDefault(replaceVariant, null));
    }

    public static BakedModel getReplacementModel(DynamicPart part, Direction dir, boolean half, int slot, DynamicPart iconPart) {
        return DrawerModelStore.getReplacementModel(DrawerModelStore.getSlotVariant(part, dir, half, slot), DrawerModelStore.getVariant(iconPart));
    }

    static {
        INSTANCE.add();
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            INSTANCE.add(dir, true);
            INSTANCE.add(dir, false);
        }
    }

    public static enum DynamicPart {
        LOCK("lock"),
        CLAIM("claim"),
        LOCK_CLAIM("lock_claim"),
        VOID_ICON("void_icon"),
        SHROUD_ICON("shroud_icon"),
        SUSPEND_ICON("suspend_icon"),
        MAGNET_ICON("magnet_icon"),
        PRIORITY_P1_ICON("priority_p1_icon"),
        PRIORITY_P2_ICON("priority_p2_icon"),
        PRIORITY_N1_ICON("priority_n1_icon"),
        PRIORITY_N2_ICON("priority_n2_icon"),
        INDICATOR("indicator"),
        INDICATOR_COMP("indicator_comp"),
        RIGHT_LABEL("right_label"),
        HOPPER("hopper"),
        MISSING_1("missing_1"),
        MISSING_2("missing_2"),
        MISSING_3("missing_3"),
        MISSING_4("missing_4"),
        FRAMED_DRAWERS_SIDE("framed_drawers_side"),
        FRAMED_DRAWERS_TRIM("framed_drawers_trim"),
        FRAMED_DRAWERS_FRONT("framed_drawers_front"),
        FRAMED_DRAWERS_SHADING("framed_drawers_shading"),
        FRAMED_TRIM_SIDE("framed_trim_side"),
        FRAMED_TRIM_TRIM("framed_trim_trim"),
        FRAMED_CONTROLLER_SIDE("framed_controller_side"),
        FRAMED_CONTROLLER_TRIM("framed_controller_trim"),
        FRAMED_CONTROLLER_FRONT("framed_controller_front"),
        FRAMED_CONTROLLER_SHADING("framed_controller_shading"),
        FRAMED_CONTROLLER_IO_SIDE("framed_controller_io_side"),
        FRAMED_CONTROLLER_IO_TRIM("framed_controller_io_trim"),
        FRAMED_CONTROLLER_IO_SHADING("framed_controller_io_shading"),
        FRAMED_COMP2_SIDE("framed_comp2_side"),
        FRAMED_COMP2_TRIM("framed_comp2_trim"),
        FRAMED_COMP2_FRONT("framed_comp2_front"),
        FRAMED_COMP2_SHADING("framed_comp2_shading"),
        FRAMED_COMP3_SIDE("framed_comp3_side"),
        FRAMED_COMP3_TRIM("framed_comp3_trim"),
        FRAMED_COMP3_FRONT("framed_comp3_front"),
        FRAMED_COMP3_SHADING("framed_comp3_shading");

        private String name;

        private DynamicPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class DecorationSet {
        public final Set<String> targetBlocks = new HashSet<String>();
        public final Map<String, ModelResourceLocation> overlays = new HashMap<String, ModelResourceLocation>();

        public DecorationSet() {
            ModBlocks.getDrawersOfType(BlockDrawers.class).forEach(blockDrawers -> {
                for (BlockState state : blockDrawers.m_49965_().m_61056_()) {
                    this.targetBlocks.add(BlockModelShaper.m_110895_((BlockState)state).toString());
                }
            });
            ModBlocks.getFramedBlocks().forEach(blockTrim -> {
                if (blockTrim instanceof Block) {
                    Block mcBlock = (Block)blockTrim;
                    for (BlockState state : mcBlock.m_49965_().m_61056_()) {
                        this.targetBlocks.add(BlockModelShaper.m_110895_((BlockState)state).toString());
                    }
                    ModelResourceLocation invLoc = new ModelResourceLocation(BuiltInRegistries.f_256975_.m_7981_((Object)mcBlock), "inventory");
                    this.targetBlocks.add(invLoc.toString());
                }
            });
        }

        public void add() {
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.VOID_ICON), new ModelResourceLocation(ModConstants.loc("meta_void_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.SHROUD_ICON), new ModelResourceLocation(ModConstants.loc("meta_shroud_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.SUSPEND_ICON), new ModelResourceLocation(ModConstants.loc("meta_suspend_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MAGNET_ICON), new ModelResourceLocation(ModConstants.loc("meta_magnet_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_P1_ICON), new ModelResourceLocation(ModConstants.loc("meta_priority_p1_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_P2_ICON), new ModelResourceLocation(ModConstants.loc("meta_priority_p2_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_N1_ICON), new ModelResourceLocation(ModConstants.loc("meta_priority_n1_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.PRIORITY_N2_ICON), new ModelResourceLocation(ModConstants.loc("meta_priority_n2_icon"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.HOPPER), new ModelResourceLocation(ModConstants.loc("meta_hopper"), DrawerModelStore.getVariant()));
        }

        public void add(Direction dir, boolean half) {
            EnumCompDrawer open;
            int i;
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.LOCK, dir, half), new ModelResourceLocation(ModConstants.loc("meta_locked"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.CLAIM, dir, half), new ModelResourceLocation(ModConstants.loc("meta_claimed"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.LOCK_CLAIM, dir, half), new ModelResourceLocation(ModConstants.loc("meta_locked_claimed"), DrawerModelStore.getVariant(dir, half)));
            for (i = 1; i <= 6; ++i) {
                this.addOverlay(DrawerModelStore.getSlotVariant(DynamicPart.RIGHT_LABEL, dir, half, i), new ModelResourceLocation(ModConstants.loc("meta_right_label"), DrawerModelStore.getSlotVariant(dir, half, i)));
            }
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 1), new ModelResourceLocation(ModConstants.loc("meta_indicator"), DrawerModelStore.getVariant(dir, half, 1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_indicator"), DrawerModelStore.getVariant(dir, half, 2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_indicator"), DrawerModelStore.getVariant(dir, half, 4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR_COMP, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_comp_indicator"), DrawerModelStore.getVariant(dir, half, 2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.INDICATOR_COMP, dir, half, 3), new ModelResourceLocation(ModConstants.loc("meta_comp_indicator"), DrawerModelStore.getVariant(dir, half, 3)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 1), new ModelResourceLocation(ModConstants.loc("meta_missing_slot_1_1"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_missing_slot_2_1"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_1, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_missing_slot_4_1"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_2, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_missing_slot_2_2"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_2, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_missing_slot_4_2"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_3, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_missing_slot_4_3"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.MISSING_4, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_missing_slot_4_4"), DrawerModelStore.getVariant(dir, half)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 1), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_side"), DrawerModelStore.getVariant(dir, half, 1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_side"), DrawerModelStore.getVariant(dir, half, 2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SIDE, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_side"), DrawerModelStore.getVariant(dir, half, 4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 1), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_trim"), DrawerModelStore.getVariant(dir, half, 1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_trim"), DrawerModelStore.getVariant(dir, half, 2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_TRIM, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_trim"), DrawerModelStore.getVariant(dir, half, 4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 1), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_front"), DrawerModelStore.getVariant(dir, half, 1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_front"), DrawerModelStore.getVariant(dir, half, 2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_FRONT, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_front"), DrawerModelStore.getVariant(dir, half, 4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 1), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_shading"), DrawerModelStore.getVariant(dir, half, 1)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 2), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_shading"), DrawerModelStore.getVariant(dir, half, 2)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_DRAWERS_SHADING, dir, half, 4), new ModelResourceLocation(ModConstants.loc("meta_framed_drawers_shading"), DrawerModelStore.getVariant(dir, half, 4)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_TRIM_SIDE), new ModelResourceLocation(ModConstants.loc("meta_framed_trim_side"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_TRIM_TRIM), new ModelResourceLocation(ModConstants.loc("meta_framed_trim_trim"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_SIDE, dir), new ModelResourceLocation(ModConstants.loc("meta_framed_controller_side"), DrawerModelStore.getVariant(dir)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_TRIM, dir), new ModelResourceLocation(ModConstants.loc("meta_framed_controller_trim"), DrawerModelStore.getVariant(dir)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_FRONT, dir), new ModelResourceLocation(ModConstants.loc("meta_framed_controller_front"), DrawerModelStore.getVariant(dir)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_SHADING, dir), new ModelResourceLocation(ModConstants.loc("meta_framed_controller_shading"), DrawerModelStore.getVariant(dir)));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_SIDE), new ModelResourceLocation(ModConstants.loc("meta_framed_controller_io_side"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_TRIM), new ModelResourceLocation(ModConstants.loc("meta_framed_controller_io_trim"), DrawerModelStore.getVariant()));
            this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_CONTROLLER_IO_SHADING), new ModelResourceLocation(ModConstants.loc("meta_framed_controller_io_shading"), DrawerModelStore.getVariant()));
            for (i = 1; i <= 2; ++i) {
                open = EnumCompDrawer.byOpenSlots(i);
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_SIDE, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_2_side"), DrawerModelStore.getVariant(dir, half, open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_TRIM, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_2_trim"), DrawerModelStore.getVariant(dir, half, open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_FRONT, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_2_front"), DrawerModelStore.getVariant(dir, half, open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP2_SHADING, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_2_shading"), DrawerModelStore.getVariant(dir, half, open)));
            }
            for (i = 1; i <= 3; ++i) {
                open = EnumCompDrawer.byOpenSlots(i);
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_SIDE, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_3_side"), DrawerModelStore.getVariant(dir, half, open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_TRIM, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_3_trim"), DrawerModelStore.getVariant(dir, half, open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_FRONT, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_3_front"), DrawerModelStore.getVariant(dir, half, open)));
                this.addOverlay(DrawerModelStore.getVariant(DynamicPart.FRAMED_COMP3_SHADING, dir, half, open), new ModelResourceLocation(ModConstants.loc("meta_framed_compdrawers_3_shading"), DrawerModelStore.getVariant(dir, half, open)));
            }
        }

        void addOverlay(String variant, ModelResourceLocation loc) {
            this.overlays.put(variant, DrawerModelStore.addLocation(loc));
        }

        public boolean isTargetedModel(ModelResourceLocation loc) {
            if (loc == null) {
                return false;
            }
            return this.targetBlocks.contains(loc.toString());
        }
    }

    public static class FrameMatSet {
        private DynamicPart sidePart;
        private DynamicPart trimPart;
        private DynamicPart frontPart;
        private DynamicPart shadeFrontPart;
        private DynamicPart shadeSidePart;

        public DynamicPart sidePart() {
            return this.sidePart;
        }

        public DynamicPart trimPart() {
            return this.trimPart;
        }

        public DynamicPart frontPart() {
            return this.frontPart;
        }

        public DynamicPart shadeFrontPart() {
            return this.shadeFrontPart;
        }

        public DynamicPart shadeSidePart() {
            return this.shadeSidePart;
        }

        public FrameMatSet sidePart(DynamicPart part) {
            this.sidePart = part;
            return this;
        }

        public FrameMatSet trimPart(DynamicPart part) {
            this.trimPart = part;
            return this;
        }

        public FrameMatSet frontPart(DynamicPart part) {
            this.frontPart = part;
            return this;
        }

        public FrameMatSet shadeFrontPart(DynamicPart part) {
            this.shadeFrontPart = part;
            return this;
        }

        public FrameMatSet shadeSidePart(DynamicPart part) {
            this.shadeSidePart = part;
            return this;
        }
    }
}

