/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.InventoryCableConnectorBlock;
import com.tom.storagemod.gui.InventoryConnectorFilterMenu;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.tile.AbstractInventoryCableConnectorBlockEntity;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.FilteredInventoryHandler;
import com.tom.storagemod.util.ItemFilterHandler;
import com.tom.storagemod.util.Priority;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class FilteredInventoryCableConnectorBlockEntity
extends AbstractInventoryCableConnectorBlockEntity
implements MenuProvider {
    private SimpleContainer filter = new SimpleContainer(9){

        public boolean m_6542_(Player p_59619_) {
            return FilteredInventoryCableConnectorBlockEntity.this.stillValid(p_59619_);
        }
    };
    private boolean allowList = true;
    private boolean keepLastInSlot;
    private Priority priority = Priority.NORMAL;

    public FilteredInventoryCableConnectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.invCableConnectorFilteredTile.get(), pos, state);
    }

    @Override
    protected LazyOptional<IItemHandler> applyFilter(LazyOptional<IItemHandler> to) {
        return to.lazyMap(h -> {
            ItemFilterHandler fh = new ItemFilterHandler((Container)this.filter, BlockFace.touching(this.f_58857_, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)InventoryCableConnectorBlock.FACING)));
            return new FilteredInventoryHandler((IItemHandler)h, s -> fh.test(s) == this.allowList, this.keepLastInSlot);
        });
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("filter", (Tag)this.filter.m_7927_());
        tag.m_128379_("allowList", this.allowList);
        tag.m_128405_("priority", this.priority.ordinal());
        tag.m_128379_("keepLast", this.keepLastInSlot);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.filter.m_7797_(tag.m_128437_("filter", 10));
        this.allowList = tag.m_128441_("allowList") ? tag.m_128471_("allowList") : true;
        this.priority = tag.m_128441_("priority") ? Priority.VALUES[Math.abs(tag.m_128451_("priority")) % Priority.VALUES.length] : Priority.NORMAL;
        this.keepLastInSlot = tag.m_128471_("keepLast");
    }

    public AbstractContainerMenu m_7208_(int arg0, Inventory arg1, Player arg2) {
        return new InventoryConnectorFilterMenu(arg0, arg1, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"ts.connector_filtered");
    }

    public boolean stillValid(Player p_59619_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(p_59619_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void dropFilters() {
        for (int i = 0; i < this.filter.m_6643_(); ++i) {
            ItemStack is = this.filter.m_8020_(i);
            if (!(is.m_41720_() instanceof IItemFilter)) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)is);
        }
    }

    public SimpleContainer getFilter() {
        return this.filter;
    }

    public void setAllowList(boolean b) {
        this.allowList = b;
        this.m_6596_();
    }

    public boolean isAllowList() {
        return this.allowList;
    }

    public void setPriority(Priority p) {
        this.priority = p;
        this.m_6596_();
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setKeepLastInSlot(boolean keepLastInSlot) {
        this.keepLastInSlot = keepLastInSlot;
    }

    public boolean isKeepLastInSlot() {
        return this.keepLastInSlot;
    }

    @Override
    protected void initLinv() {
        this.linv.priority = this.priority;
    }
}

