/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.client.particle;

import galena.oreganized.index.OParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomDrippingParticle
extends TextureSheetParticle {
    private final Fluid type;
    protected boolean isGlowing;

    CustomDrippingParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType) {
        super(pLevel, pX, pY, pZ);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.06f;
        this.type = pType;
    }

    protected Fluid getType() {
        return this.type;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float pPartialTick) {
        return this.isGlowing ? 240 : super.m_6355_(pPartialTick);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                BlockPos blockpos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
                FluidState fluidstate = this.f_107208_.m_6425_(blockpos);
                if (fluidstate.m_76152_() == this.type && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeadLandProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public LeadLandProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            DripLandParticle dripparticle = new DripLandParticle(pLevel, pX, pY, pZ, (Fluid)Fluids.f_76195_);
            dripparticle.m_107253_(0.35f, 0.24f, 0.43f);
            dripparticle.m_108335_(this.sprite);
            return dripparticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeadHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public LeadHangProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            CoolingDripHangParticle dripparticle$coolingdriphangparticle = new CoolingDripHangParticle(pLevel, pX, pY, pZ, (Fluid)Fluids.f_76195_, (ParticleOptions)OParticleTypes.FALLING_LEAD.get());
            dripparticle$coolingdriphangparticle.m_107253_(0.35f, 0.24f, 0.43f);
            dripparticle$coolingdriphangparticle.m_108335_(this.sprite);
            return dripparticle$coolingdriphangparticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeadFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public LeadFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FallAndLandParticle dripparticle = new FallAndLandParticle(pLevel, pX, pY, pZ, (Fluid)Fluids.f_76195_, (ParticleOptions)OParticleTypes.LANDING_LEAD.get());
            dripparticle.m_107253_(0.35f, 0.24f, 0.43f);
            dripparticle.m_108335_(this.sprite);
            return dripparticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingParticle
    extends CustomDrippingParticle {
        FallingParticle(ClientLevel p_106132_, double p_106133_, double p_106134_, double p_106135_, Fluid p_106136_) {
            this(p_106132_, p_106133_, p_106134_, p_106135_, p_106136_, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        FallingParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, int pLifetime) {
            super(pLevel, pX, pY, pZ, pType);
            this.f_107225_ = pLifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallAndLandParticle
    extends FallingParticle {
        protected final ParticleOptions landParticle;

        FallAndLandParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, ParticleOptions pLandParticle) {
            super(pLevel, pX, pY, pZ, pType);
            this.landParticle = pLandParticle;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripLandParticle
    extends CustomDrippingParticle {
        DripLandParticle(ClientLevel p_106102_, double p_106103_, double p_106104_, double p_106105_, Fluid p_106106_) {
            super(p_106102_, p_106103_, p_106104_, p_106105_, p_106106_);
            this.f_107225_ = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripHangParticle
    extends CustomDrippingParticle {
        private final ParticleOptions fallingParticle;

        DripHangParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, ParticleOptions pFallingParticle) {
            super(pLevel, pX, pY, pZ, pType);
            this.fallingParticle = pFallingParticle;
            this.f_107226_ *= 0.02f;
            this.f_107225_ = 40;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.fallingParticle, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CoolingDripHangParticle
    extends DripHangParticle {
        CoolingDripHangParticle(ClientLevel p_106068_, double p_106069_, double p_106070_, double p_106071_, Fluid p_106072_, ParticleOptions p_106073_) {
            super(p_106068_, p_106069_, p_106070_, p_106071_, p_106072_, p_106073_);
        }

        @Override
        protected void preMoveUpdate() {
            this.f_107227_ = Math.max(0.55f - (float)(40 - this.f_107225_) / 10.0f / 8.0f, 0.35f);
            this.f_107228_ = Math.max(0.44f - (float)(40 - this.f_107225_) / 10.0f / 8.0f, 0.24f);
            this.f_107229_ = Math.max(0.62f - (float)(40 - this.f_107225_) / 10.0f / 8.0f, 0.42f);
            super.preMoveUpdate();
        }
    }
}

