/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.other;

import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.other.tags.BlueprintEntityTypeTags;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.caverns_and_chasms.common.block.BrazierBlock;
import com.teamabnormals.caverns_and_chasms.common.entity.ControllableGolem;
import com.teamabnormals.caverns_and_chasms.common.entity.ai.goal.FollowTuningForkGoal;
import com.teamabnormals.caverns_and_chasms.common.entity.animal.Fly;
import com.teamabnormals.caverns_and_chasms.common.entity.animal.Rat;
import com.teamabnormals.caverns_and_chasms.common.entity.monster.Deeper;
import com.teamabnormals.caverns_and_chasms.common.entity.monster.Peeper;
import com.teamabnormals.caverns_and_chasms.common.entity.projectile.BluntArrow;
import com.teamabnormals.caverns_and_chasms.common.item.NetheriteHorseArmorItem;
import com.teamabnormals.caverns_and_chasms.common.item.SanguineArmorItem;
import com.teamabnormals.caverns_and_chasms.common.item.TetherPotionItem;
import com.teamabnormals.caverns_and_chasms.common.item.TuningForkItem;
import com.teamabnormals.caverns_and_chasms.common.item.necromium.NecromiumHorseArmorItem;
import com.teamabnormals.caverns_and_chasms.common.item.silver.SilverHorseArmorItem;
import com.teamabnormals.caverns_and_chasms.common.item.silver.SilverItem;
import com.teamabnormals.caverns_and_chasms.core.CCConfig;
import com.teamabnormals.caverns_and_chasms.core.other.CCDataProcessors;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCBlockTags;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCItemTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCAttributes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.caverns_and_chasms.core.registry.CCMobEffects;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="caverns_and_chasms")
public class CCEvents {
    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            zombie.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)zombie, Fly.class, 9.0f, 1.05, 1.05));
            return;
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            if (!(entity instanceof SkeletonHorse)) {
                horse.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)horse, Fly.class, 8.0f, 1.1, 1.1));
                return;
            }
        }
        if (entity instanceof Spider) {
            Spider spider = (Spider)entity;
            spider.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)spider, Fly.class, false));
            return;
        }
        if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            golem.f_21345_.m_25352_(0, (Goal)new FollowTuningForkGoal((ControllableGolem)golem, 0.9));
            golem.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)golem, LivingEntity.class, 5, false, false, target -> ((ControllableGolem)golem).isTuningForkTarget((LivingEntity)target)));
            return;
        }
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            cat.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)cat, Rat.class, false, target -> {
                Rat rat;
                return target instanceof Rat && !(rat = (Rat)((Object)target)).m_21824_();
            }));
            return;
        }
        if (!(entity instanceof Ocelot)) return;
        Ocelot ocelot = (Ocelot)entity;
        ocelot.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)ocelot, Rat.class, false));
    }

    @SubscribeEvent
    public static void rightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        LivingEntity entity;
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack stack = player.m_21120_(event.getHand());
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        if (target instanceof LivingEntity && (entity = (LivingEntity)target).m_6095_().m_204039_(BlueprintEntityTypeTags.MILKABLE) && !entity.m_6162_() && (stack.m_41720_() == CCItems.GOLDEN_MILK_BUCKET.get() || stack.m_41720_() == CCItems.GOLDEN_BUCKET.get())) {
            CompoundTag tag = stack.m_41784_();
            ItemStack milkBucket = ItemUtils.m_41813_((ItemStack)stack.m_41777_(), (Player)player, (ItemStack)((Item)CCItems.GOLDEN_MILK_BUCKET.get()).m_7968_());
            boolean fullBucket = false;
            if (stack.m_41720_() == CCItems.GOLDEN_MILK_BUCKET.get()) {
                boolean bl = fullBucket = tag.m_128451_("FluidLevel") >= 2;
                if (!fullBucket && !player.m_7500_()) {
                    milkBucket.m_41784_().m_128405_("FluidLevel", tag.m_128451_("FluidLevel") + 1);
                }
            }
            if (!fullBucket) {
                Goat goat;
                player.m_5496_(entity instanceof Goat ? ((goat = (Goat)entity).m_149397_() ? SoundEvents.f_144148_ : SoundEvents.f_144168_) : SoundEvents.f_11833_, 1.0f, 1.0f);
                target.m_146850_(GameEvent.f_223708_);
                player.m_21008_(hand, milkBucket);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Creeper creeper;
        boolean validSpawn;
        Mob entity = event.getEntity();
        ServerLevelAccessor world = event.getLevel();
        boolean bl = validSpawn = event.getSpawnType() == MobSpawnType.NATURAL || event.getSpawnType() == MobSpawnType.CHUNK_GENERATION;
        if (event.getResult() != Event.Result.DENY && validSpawn && entity.m_6095_() == EntityType.f_20558_ && event.getY() < (double)((Integer)CCConfig.COMMON.deeperMaxSpawnHeight.get()).intValue() && world.m_8055_((creeper = (Creeper)entity).m_20183_().m_7495_()).m_204336_(CCBlockTags.DEEPER_SPAWNABLE_ON)) {
            if (event.getY() < (double)((Integer)CCConfig.COMMON.peeperMaxSpawnHeight.get()).intValue() && entity.m_217043_().m_188501_() < 0.7f) {
                Peeper peeper = (Peeper)((EntityType)CCEntityTypes.PEEPER.get()).m_20615_((Level)world);
                if (peeper != null) {
                    peeper.m_20359_((Entity)creeper);
                    world.m_7967_((Entity)peeper);
                }
            } else {
                Deeper deeper = (Deeper)((EntityType)CCEntityTypes.DEEPER.get()).m_20615_((Level)world);
                if (deeper != null) {
                    deeper.m_20359_((Entity)creeper);
                    world.m_7967_((Entity)deeper);
                }
            }
            event.setSpawnCancelled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            if (event.getPlacedBlock().m_60713_((Block)CCBlocks.ROTTEN_FLESH_BLOCK.get())) {
                LevelAccessor level = event.getLevel();
                BlockPos pos = event.getPos();
                List rats = level.m_6443_(Rat.class, new AABB(pos).m_82377_(8.0, 4.0, 8.0), entity -> entity.m_6084_() && !entity.m_21824_());
                rats.stream().limit(9L).toList().forEach(rat -> rat.setTamer(player));
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        BlockState state = level.m_8055_(pos);
        Direction face = event.getFace();
        RandomSource random = level.m_213780_();
        if (state.m_60734_() instanceof BrazierBlock && face == Direction.UP) {
            if (stack.canPerformAction(ToolActions.SHOVEL_FLATTEN) && ((Boolean)state.m_61143_((Property)BrazierBlock.LIT)).booleanValue()) {
                BlockState extinguishedState = BrazierBlock.extinguish((Entity)player, (LevelAccessor)level, pos, state);
                if (!level.m_5776_()) {
                    level.m_5898_(null, 1009, pos, 0);
                    level.m_7731_(pos, extinguishedState, 11);
                    stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(event.getHand()));
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            }
            if (BrazierBlock.canBeLit(state)) {
                if (stack.m_41720_() instanceof FlintAndSteelItem) {
                    level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, random.m_188501_() * 0.4f + 0.8f);
                    if (!level.m_5776_()) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BrazierBlock.LIT, (Comparable)Boolean.valueOf(true)), 11);
                        level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                        stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(event.getHand()));
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                } else if (stack.m_41720_() instanceof FireChargeItem) {
                    level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (random.m_188501_() - random.m_188501_()) * 0.2f + 1.0f);
                    if (!level.m_5776_()) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BrazierBlock.LIT, (Comparable)Boolean.valueOf(true)), 11);
                        level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                }
            }
        }
        if (state.m_60734_() instanceof NoteBlock && item == CCItems.TUNING_FORK.get()) {
            CompoundTag tag = stack.m_41784_();
            if (!player.m_6047_() && tag.m_128441_("Note")) {
                int note = tag.m_128451_("Note");
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)NoteBlock.f_55013_, (Comparable)Integer.valueOf(Mth.m_14045_((int)note, (int)0, (int)24))));
                player.m_5661_((Component)Component.m_237110_((String)(item.m_5524_() + ".change_note"), (Object[])new Object[]{Component.m_237115_((String)(item.m_5524_() + ".note." + note))}).m_130946_(" (" + note + ")"), true);
                if (!level.m_5776_() && level.m_8055_(pos.m_7494_()).m_60795_()) {
                    level.m_7696_(pos, state.m_60734_(), 0, 0);
                    level.m_142346_((Entity)player, GameEvent.f_223699_, pos);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            }
        }
        if (((Boolean)CCConfig.COMMON.betterRailPlacement.get()).booleanValue() && state.m_60734_() instanceof BaseRailBlock && !stack.m_204117_(CCItemTags.IGNORE_RAIL_PLACEMENT) && item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof BaseRailBlock && !state.m_204336_(CCBlockTags.IGNORE_RAIL_PLACEMENT)) {
            Direction direction = player.m_6350_();
            BlockPos.MutableBlockPos currentPos = event.getPos().m_122032_().m_122173_(direction);
            for (int i = 0; i < (Integer)CCConfig.COMMON.betterRailPlacementRange.get(); ++i) {
                BlockPos nextPos = null;
                boolean isNextRail = false;
                BlockPos.MutableBlockPos yCheckingPos = currentPos.m_122032_().m_122173_(Direction.DOWN);
                for (int j = 0; j < 3; ++j) {
                    BlockState stateAtCheckPos = level.m_8055_((BlockPos)yCheckingPos);
                    if (stateAtCheckPos.m_60734_() instanceof BaseRailBlock && !stateAtCheckPos.m_204336_(CCBlockTags.IGNORE_RAIL_PLACEMENT)) {
                        nextPos = yCheckingPos.m_122173_(direction).m_7949_();
                        isNextRail = true;
                    } else if (!isNextRail) {
                        BlockState stateForPlacement;
                        BlockPlaceContext context = new BlockPlaceContext(player, event.getHand(), event.getItemStack(), event.getHitVec().m_82430_((BlockPos)yCheckingPos));
                        if (level.m_8055_((BlockPos)yCheckingPos).m_60629_(context) && (stateForPlacement = state.m_60734_().m_5573_(context)) != null && stateForPlacement.m_60710_((LevelReader)level, (BlockPos)yCheckingPos)) {
                            nextPos = yCheckingPos.m_7949_();
                        }
                    }
                    yCheckingPos.m_122173_(Direction.UP);
                }
                if (!isNextRail) {
                    if (nextPos == null) break;
                    BlockPlaceContext context = new BlockPlaceContext(player, event.getHand(), event.getItemStack(), event.getHitVec().m_82430_(nextPos));
                    ((BlockItem)item).m_40576_(context);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    break;
                }
                currentPos.m_122190_(nextPos);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().m_60713_(Blocks.f_152491_)) {
            event.setNewSpeed(event.getOriginalSpeed() / 8.0f);
        }
    }

    @SubscribeEvent
    public static void bonusXPBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_6844_(EquipmentSlot.MAINHAND);
        Collection experienceModifiers = stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)((Attribute)CCAttributes.EXPERIENCE_BOOST.get()));
        if (!experienceModifiers.isEmpty()) {
            float experienceBoost = (float)event.getExpToDrop() * (float)experienceModifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
            int base = Mth.m_14143_((float)experienceBoost);
            float bonus = Mth.m_14187_((float)experienceBoost);
            if (bonus != 0.0f && Math.random() < (double)bonus) {
                ++base;
            }
            event.setExpToDrop(event.getExpToDrop() + base);
        }
    }

    @SubscribeEvent
    public static void bonusXPMobs(LivingExperienceDropEvent event) {
        ItemStack stack;
        Collection experienceModifiers;
        Player player = event.getAttackingPlayer();
        if (player != null && !(experienceModifiers = (stack = player.m_6844_(EquipmentSlot.MAINHAND)).m_41638_(EquipmentSlot.MAINHAND).get((Object)((Attribute)CCAttributes.EXPERIENCE_BOOST.get()))).isEmpty()) {
            float experienceBoost = (float)((double)event.getDroppedExperience() * experienceModifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum());
            int base = Mth.m_14143_((float)experienceBoost);
            float bonus = Mth.m_14187_((float)experienceBoost);
            if (bonus != 0.0f && Math.random() < (double)bonus) {
                ++base;
            }
            event.setDroppedExperience(event.getDroppedExperience() + base);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        ItemStack stack;
        if (event.getSlot() == EquipmentSlot.HEAD && (stack = event.getFrom()).m_41720_() == CCItems.TETHER_POTION.get()) {
            TetherPotionItem.updateTetherPotionEffects(event.getEntity(), stack, false);
        }
    }

    @SubscribeEvent
    public static void potionAddedEvent(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (event.getEffectInstance().m_19544_() == CCMobEffects.REWIND.get() && !entity.m_21023_((MobEffect)CCMobEffects.REWIND.get())) {
            IDataManager data = (IDataManager)entity;
            data.setValue(CCDataProcessors.REWIND_DIMENSION, (Object)entity.m_20193_().m_46472_().m_135782_());
            data.setValue(CCDataProcessors.REWIND_X, (Object)entity.m_20185_());
            data.setValue(CCDataProcessors.REWIND_Y, (Object)entity.m_20186_());
            data.setValue(CCDataProcessors.REWIND_Z, (Object)entity.m_20189_());
        }
    }

    @SubscribeEvent
    public static void potionRemoveEvent(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MobEffect effect = effectInstance.m_19544_();
            LivingEntity entity = event.getEntity();
            if (effect == CCMobEffects.REWIND.get()) {
                CCEvents.rewindTeleport(entity);
            }
        }
    }

    @SubscribeEvent
    public static void potionExpireEvent(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            MobEffect effect = effectInstance.m_19544_();
            LivingEntity entity = event.getEntity();
            if (effect == CCMobEffects.REWIND.get()) {
                CCEvents.rewindTeleport(entity);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity horse;
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTags.f_268731_)) {
            float magicProtection = 0.0f;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack;
                Collection magicProt;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (magicProt = (stack = target.m_6844_(slot)).m_41638_(slot).get((Object)((Attribute)CCAttributes.MAGIC_PROTECTION.get()))).isEmpty()) continue;
                magicProtection = (float)((double)magicProtection + magicProt.stream().mapToDouble(AttributeModifier::m_22218_).sum());
            }
            if (magicProtection > 0.0f) {
                event.setAmount(event.getAmount() - event.getAmount() * magicProtection);
                SilverItem.causeMagicProtectionParticles(target);
            }
            if (target instanceof Horse) {
                horse = (Horse)target;
                for (ItemStack stack : horse.m_6168_()) {
                    if (!(stack.m_41720_() instanceof SilverHorseArmorItem)) continue;
                    event.setAmount(event.getAmount() - event.getAmount() * 0.3f);
                    SilverItem.causeMagicProtectionParticles((LivingEntity)horse);
                }
            }
        }
        if ((horse = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)horse;
            ItemStack mainHandItem = attacker.m_21205_();
            if (TuningForkItem.isTuningForkWithNote(mainHandItem)) {
                int note = mainHandItem.m_41783_().m_128451_("Note");
                TuningForkItem.playNote(target.m_9236_(), (Entity)attacker, target.m_20185_(), target.m_20188_(), target.m_20189_(), note);
                NetworkUtil.spawnParticle((String)"minecraft:note", (double)target.m_20185_(), (double)target.m_20188_(), (double)target.m_20189_(), (double)((double)note / 24.0), (double)0.0, (double)0.0);
                if (attacker instanceof Player) {
                    ((Player)attacker).m_5661_((Component)Component.m_237115_((String)(((Item)CCItems.TUNING_FORK.get()).m_5524_() + ".note")).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)(((Item)CCItems.TUNING_FORK.get()).m_5524_() + ".note." + note))).m_130946_(" (" + note + ")"), true);
                    TuningForkItem.orderGolemToAttackEntity(target, (Player)attacker);
                }
            }
            float weaknessAmount = 0.0f;
            float lifeStealAmount = 0.0f;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                Collection lifeStealModifiers;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ItemStack stack = target.m_6844_(slot);
                Collection weaknessModifiers = stack.m_41638_(slot).get((Object)((Attribute)CCAttributes.WEAKNESS_AURA.get()));
                if (!weaknessModifiers.isEmpty()) {
                    weaknessAmount = (float)((double)weaknessAmount + weaknessModifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum());
                }
                if ((lifeStealModifiers = attacker.m_6844_(slot).m_41638_(slot).get((Object)((Attribute)CCAttributes.LIFESTEAL.get()))).isEmpty() || !(target instanceof Enemy) && !(target instanceof Player)) continue;
                lifeStealAmount = (float)((double)lifeStealAmount + lifeStealModifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum());
            }
            if (lifeStealAmount > 0.0f) {
                attacker.m_5634_(lifeStealAmount * event.getAmount());
                SanguineArmorItem.causeHealParticles(attacker, lifeStealAmount);
            }
            if (weaknessAmount > 0.0f) {
                for (LivingEntity entity : target.m_20193_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_((double)weaknessAmount, 0.0, (double)weaknessAmount))) {
                    if (entity == target) continue;
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60));
                }
            }
            if (target instanceof Horse) {
                Horse horse2 = (Horse)target;
                for (ItemStack stack : horse2.m_6168_()) {
                    if (!(stack.m_41720_() instanceof NecromiumHorseArmorItem)) continue;
                    for (LivingEntity entity : target.m_20193_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(2.0, 0.0, 2.0))) {
                        if (entity == target || target.m_20363_((Entity)entity)) continue;
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60));
                    }
                }
            }
        }
        if (source.m_7640_() instanceof BluntArrow) {
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Level level = target.m_9236_();
        ItemStack headstack = target.m_6844_(EquipmentSlot.HEAD);
        if (headstack.m_41720_() == CCItems.TETHER_POTION.get() && !source.m_269533_(DamageTypeTags.f_268490_)) {
            Player player = target instanceof Player ? (Player)target : null;
            target.m_21166_(EquipmentSlot.HEAD);
            target.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
            for (MobEffectInstance instance : PotionUtils.m_43547_((ItemStack)headstack)) {
                if (!instance.m_19544_().m_8093_()) continue;
                instance.m_19544_().m_19461_((Entity)player, (Entity)player, target, instance.m_19564_(), 1.0);
            }
            int i = PotionUtils.m_43579_((ItemStack)headstack).m_43491_() ? 2007 : 2002;
            level.m_46796_(i, BlockPos.m_274446_((Position)target.m_20299_(1.0f)), PotionUtils.m_43575_((ItemStack)headstack));
        }
    }

    @SubscribeEvent
    public static void visibilityEvent(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity entity = event.getEntity();
        EntityType looking = event.getLookingEntity().m_6095_();
        ItemStack stack = entity.m_6844_(EquipmentSlot.HEAD);
        if (looking == CCEntityTypes.DEEPER.get() && stack.m_150930_((Item)CCItems.DEEPER_HEAD.get()) || looking == CCEntityTypes.PEEPER.get() && stack.m_150930_((Item)CCItems.PEEPER_HEAD.get()) || looking == CCEntityTypes.MIME.get() && stack.m_150930_((Item)CCItems.MIME_HEAD.get())) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent
    public static void knockbackEvent(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Horse) {
            Horse horse = (Horse)livingEntity;
            for (ItemStack stack : horse.m_6168_()) {
                Item item = stack.m_41720_();
                if (!(item instanceof NetheriteHorseArmorItem)) continue;
                NetheriteHorseArmorItem horseArmorItem = (NetheriteHorseArmorItem)item;
                event.setStrength(event.getStrength() * (1.0f - horseArmorItem.getKnockbackResistance()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemModify(ItemAttributeModifierEvent event) {
        ArmorItem.Type type;
        ItemStack stack = event.getItemStack();
        EquipmentSlot slot = event.getSlotType();
        switch (slot) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HEAD: {
                ArmorItem.Type type2 = ArmorItem.Type.HELMET;
                break;
            }
            case CHEST: {
                ArmorItem.Type type2 = ArmorItem.Type.CHESTPLATE;
                break;
            }
            case LEGS: {
                ArmorItem.Type type2 = ArmorItem.Type.LEGGINGS;
                break;
            }
            case FEET: {
                ArmorItem.Type type2 = ArmorItem.Type.BOOTS;
                break;
            }
            case MAINHAND: 
            case OFFHAND: {
                ArmorItem.Type type2 = type = null;
            }
        }
        if (type != null) {
            UUID uuid = (UUID)ArmorItem.f_265987_.get(type);
            if (((Boolean)CCConfig.COMMON.chainmailArmorIncreasesDamage.get()).booleanValue() && (stack.m_150930_(Items.f_42464_) && slot == EquipmentSlot.HEAD || stack.m_150930_(Items.f_42467_) && slot == EquipmentSlot.FEET || stack.m_150930_(Items.f_42465_) && slot == EquipmentSlot.CHEST || stack.m_150930_(Items.f_42466_) && slot == EquipmentSlot.LEGS)) {
                event.addModifier(Attributes.f_22281_, new AttributeModifier(uuid, "Damage boost", 1.0, AttributeModifier.Operation.ADDITION));
            }
            if (((Boolean)CCConfig.COMMON.goldenArmorIncreasesSpeed.get()).booleanValue() && (stack.m_150930_(Items.f_42476_) && slot == EquipmentSlot.HEAD || stack.m_150930_(Items.f_42479_) && slot == EquipmentSlot.FEET || stack.m_150930_(Items.f_42477_) && slot == EquipmentSlot.CHEST || stack.m_150930_(Items.f_42478_) && slot == EquipmentSlot.LEGS)) {
                event.addModifier(Attributes.f_22279_, new AttributeModifier(uuid, "Speed boost", 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
        if (slot == EquipmentSlot.MAINHAND) {
            if (stack.m_204117_(CCItemTags.EXPERIENCE_BOOST_ITEMS)) {
                event.addModifier((Attribute)CCAttributes.EXPERIENCE_BOOST.get(), new AttributeModifier(UUID.fromString("1B1C193D-1484-4CB9-8DC7-FE226C77657A"), "Exerience boost", 0.75, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if (stack.m_204117_(CCItemTags.MAGIC_DAMAGE_ITEMS)) {
                float damage = stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof SwordItem ? 3.0f : 1.0f;
                event.addModifier((Attribute)CCAttributes.MAGIC_DAMAGE.get(), new AttributeModifier(UUID.fromString("b3406524-886c-49c3-94e6-88edd0e8e63b"), "Magic damage", (double)damage, AttributeModifier.Operation.ADDITION));
            }
            if (stack.m_204117_(CCItemTags.SLOWNESS_INFLICTING_ITEMS)) {
                event.addModifier((Attribute)CCAttributes.SLOWNESS_INFLICTION.get(), new AttributeModifier(UUID.fromString("47b62d26-2010-4a6a-9f87-ebe11c50f467"), "Slowness infliction", 1.0, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IDataManager data = (IDataManager)entity;
            if (((Optional)data.getValue(CCDataProcessors.CONTROLLED_GOLEM_UUID)).isPresent()) {
                ControllableGolem golem = TuningForkItem.findControlledGolem(player);
                if (golem != null) {
                    int forgettime = TuningForkItem.getForgetGolemTime(player);
                    if (forgettime > 0) {
                        if (!TuningForkItem.isTuningForkWithNote(player.m_21205_()) && !TuningForkItem.isTuningForkWithNote(player.m_21206_())) {
                            TuningForkItem.setForgetGolemTime(player, forgettime - 1);
                        }
                    } else {
                        TuningForkItem.setControlledGolem(player, null);
                    }
                } else {
                    TuningForkItem.setControlledGolem(player, null);
                }
            }
        } else if (entity instanceof ControllableGolem) {
            ControllableGolem golem = (ControllableGolem)entity;
            boolean controlled = golem.getTuningForkController() != null;
            golem.setBeingTuningForkControlled(controlled);
            if (controlled) {
                golem.tungingForkControlTick();
            } else {
                golem.setTuningForkPos(null);
                golem.setTuningForkTarget(null);
            }
        }
        ItemStack headstack = entity.m_6844_(EquipmentSlot.HEAD);
        if (!level.m_5776_() && headstack.m_41720_() == CCItems.TETHER_POTION.get()) {
            TetherPotionItem.updateTetherPotionEffects(entity, headstack, true);
        }
    }

    private static void rewindTeleport(LivingEntity entity) {
        IDataManager data = (IDataManager)entity;
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)((ResourceLocation)data.getValue(CCDataProcessors.REWIND_DIMENSION)));
        ServerLevel dimension = entity.m_20194_().m_129880_(key);
        if (dimension != entity.m_20193_()) {
            entity.changeDimension(dimension, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    return repositionEntity.apply(false);
                }
            });
        }
        double x = (Double)data.getValue(CCDataProcessors.REWIND_X);
        double y = (Double)data.getValue(CCDataProcessors.REWIND_Y);
        double z = (Double)data.getValue(CCDataProcessors.REWIND_Z);
        if (entity.m_20159_()) {
            entity.m_142098_(x, y, z);
        } else {
            entity.m_6021_(x, y, z);
        }
        entity.m_6021_(((Double)data.getValue(CCDataProcessors.REWIND_X)).doubleValue(), ((Double)data.getValue(CCDataProcessors.REWIND_Y)).doubleValue(), ((Double)data.getValue(CCDataProcessors.REWIND_Z)).doubleValue());
        entity.m_183634_();
        entity.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
    }
}

