/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.mixin;

import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    protected MobMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="TAIL")})
    private void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty, CallbackInfo info) {
        if (random.m_188501_() < 0.5f) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack;
                Item silverItem;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (silverItem = this.replaceSilverWithGold(stack = this.m_6844_(slot))) == null) continue;
                this.m_8061_(slot, new ItemStack((ItemLike)silverItem));
            }
        }
    }

    private Item replaceSilverWithGold(ItemStack goldItem) {
        if (goldItem.m_150930_(Items.f_42476_)) {
            return (Item)CCItems.SILVER_HELMET.get();
        }
        if (goldItem.m_150930_(Items.f_42477_)) {
            return (Item)CCItems.SILVER_CHESTPLATE.get();
        }
        if (goldItem.m_150930_(Items.f_42478_)) {
            return (Item)CCItems.SILVER_LEGGINGS.get();
        }
        if (goldItem.m_150930_(Items.f_42479_)) {
            return (Item)CCItems.SILVER_BOOTS.get();
        }
        if (goldItem.m_150930_(Items.f_42430_)) {
            return (Item)CCItems.SILVER_SWORD.get();
        }
        if (goldItem.m_150930_(Items.f_42432_)) {
            return (Item)CCItems.SILVER_PICKAXE.get();
        }
        if (goldItem.m_150930_(Items.f_42434_)) {
            return (Item)CCItems.SILVER_HOE.get();
        }
        if (goldItem.m_150930_(Items.f_42433_)) {
            return (Item)CCItems.SILVER_AXE.get();
        }
        if (goldItem.m_150930_(Items.f_42431_)) {
            return (Item)CCItems.SILVER_SHOVEL.get();
        }
        return null;
    }
}

