/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core;

import com.teamabnormals.blueprint.core.api.BlueprintTrims;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.caverns_and_chasms.client.model.CopperGolemModel;
import com.teamabnormals.caverns_and_chasms.client.model.DeeperModel;
import com.teamabnormals.caverns_and_chasms.client.model.FlyModel;
import com.teamabnormals.caverns_and_chasms.client.model.GlareModel;
import com.teamabnormals.caverns_and_chasms.client.model.LostGoatModel;
import com.teamabnormals.caverns_and_chasms.client.model.MimeHeadModel;
import com.teamabnormals.caverns_and_chasms.client.model.MimeModel;
import com.teamabnormals.caverns_and_chasms.client.model.PeeperHeadModel;
import com.teamabnormals.caverns_and_chasms.client.model.PeeperModel;
import com.teamabnormals.caverns_and_chasms.client.model.RatModel;
import com.teamabnormals.caverns_and_chasms.client.model.ToolboxRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.BluntArrowRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.CopperGolemRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.DeeperRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.GlareRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.KunaiRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.LargeArrowRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.LostGoatRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.MimeRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.OxidizedCopperGolemRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.PeeperRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.TmtRenderer;
import com.teamabnormals.caverns_and_chasms.client.renderer.entity.layers.RatOnShoulderLayer;
import com.teamabnormals.caverns_and_chasms.client.resources.DeeperSpriteUploader;
import com.teamabnormals.caverns_and_chasms.common.item.TuningForkItem;
import com.teamabnormals.caverns_and_chasms.common.network.S2CSpinelBoomMessage;
import com.teamabnormals.caverns_and_chasms.core.CCConfig;
import com.teamabnormals.caverns_and_chasms.core.data.client.CCBlockStateProvider;
import com.teamabnormals.caverns_and_chasms.core.data.client.CCItemModelProvider;
import com.teamabnormals.caverns_and_chasms.core.data.client.CCSpriteSourceProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.CCAdvancementProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.CCDatapackBuiltinEntriesProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.CCLootTableProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.CCRecipeProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.modifiers.CCAdvancementModifierProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.modifiers.CCLootModifierProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCBannerPatternTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCBiomeTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCBlockTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCDamageTypeTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCEntityTypeTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCGameEventTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCInstrumentTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCItemTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCMobEffectTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCPaintingVariantTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.data.server.tags.CCTrimMaterialTagsProvider;
import com.teamabnormals.caverns_and_chasms.core.other.CCClientCompat;
import com.teamabnormals.caverns_and_chasms.core.other.CCCompat;
import com.teamabnormals.caverns_and_chasms.core.other.CCDataProcessors;
import com.teamabnormals.caverns_and_chasms.core.other.CCGameEvents;
import com.teamabnormals.caverns_and_chasms.core.other.CCInstruments;
import com.teamabnormals.caverns_and_chasms.core.other.CCModelLayers;
import com.teamabnormals.caverns_and_chasms.core.other.CCTiers;
import com.teamabnormals.caverns_and_chasms.core.registry.CCAttributes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBannerPatterns;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBiomeModifierTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlockEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCFeatures;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.caverns_and_chasms.core.registry.CCMenuTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCMobEffects;
import com.teamabnormals.caverns_and_chasms.core.registry.CCPaintingVariants;
import com.teamabnormals.caverns_and_chasms.core.registry.CCParticleTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCPoiTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCRecipes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCTrimMaterials;
import com.teamabnormals.caverns_and_chasms.core.registry.helper.CCBlockSubRegistryHelper;
import com.teamabnormals.caverns_and_chasms.integration.quark.ToolboxTooltips;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.blockentity.CampfireRenderer;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="caverns_and_chasms")
public class CavernsAndChasms {
    public static final String MOD_ID = "caverns_and_chasms";
    public static final String NETWORK_PROTOCOL = "CC1";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"caverns_and_chasms", helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new CCBlockSubRegistryHelper((RegistryHelper)helper)));
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("caverns_and_chasms", "net")).networkProtocolVersion(() -> "CC1").clientAcceptedVersions("CC1"::equals).serverAcceptedVersions("CC1"::equals).simpleChannel();

    public CavernsAndChasms() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupMessages();
        CCDataProcessors.registerTrackedData();
        REGISTRY_HELPER.register(bus);
        CCEntityTypes.ENTITY_TYPES.register(bus);
        CCAttributes.ATTRIBUTES.register(bus);
        CCMobEffects.POTIONS.register(bus);
        CCMobEffects.MOB_EFFECTS.register(bus);
        CCFeatures.FEATURES.register(bus);
        CCParticleTypes.PARTICLE_TYPES.register(bus);
        CCRecipes.CCRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        CCRecipes.CCRecipeTypes.RECIPE_TYPES.register(bus);
        CCBiomeModifierTypes.BIOME_MODIFIER_SERIALIZERS.register(bus);
        CCPaintingVariants.PAINTING_VARIANTS.register(bus);
        CCMenuTypes.MENU_TYPES.register(bus);
        CCInstruments.INSTRUMENTS.register(bus);
        CCGameEvents.GAME_EVENTS.register(bus);
        CCPoiTypes.POI_TYPES.register(bus);
        CCBannerPatterns.BANNER_PATTERNS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            CCItems.setupTabEditors();
            CCBlocks.setupTabEditors();
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
            bus.addListener(this::registerLayers);
            bus.addListener(this::registerItemColors);
            bus.addListener(this::createSkullModels);
            bus.addListener(this::registerClientTooltips);
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> DeeperSpriteUploader.init(bus));
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CCConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CCConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CCCompat.registerCompat();
            CCMobEffects.registerBrewingRecipes();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BlueprintTrims.registerArmorMaterialOverrides(CCTrimMaterials.SILVER, Map.of(CCTiers.CCArmorMaterials.SILVER, "caverns_and_chasms_silver_darker"));
        BlueprintTrims.registerArmorMaterialOverrides(CCTrimMaterials.NECROMIUM, Map.of(CCTiers.CCArmorMaterials.NECROMIUM, "caverns_and_chasms_necromium_darker"));
        BlueprintTrims.registerArmorMaterialOverrides(CCTrimMaterials.SANGUINE, Map.of(CCTiers.CCArmorMaterials.SANGUINE, "caverns_and_chasms_sanguine_darker"));
        event.enqueueWork(() -> {
            SkullBlockRenderer.f_112519_.put(CCBlocks.CCSkullTypes.DEEPER, new ResourceLocation(MOD_ID, "textures/entity/deeper/deeper.png"));
            SkullBlockRenderer.f_112519_.put(CCBlocks.CCSkullTypes.PEEPER, new ResourceLocation(MOD_ID, "textures/entity/peeper/peeper.png"));
            SkullBlockRenderer.f_112519_.put(CCBlocks.CCSkullTypes.MIME, MimeRenderer.MIME_TEXTURE);
            CCMenuTypes.registerScreenFactories();
            CCClientCompat.registerClientCompat();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        CCDatapackBuiltinEntriesProvider datapackEntries = new CCDatapackBuiltinEntriesProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        CCBlockTagsProvider blockTags = new CCBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new CCItemTagsProvider(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new CCEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCMobEffectTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCBannerPatternTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCInstrumentTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCGameEventTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCDamageTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCTrimMaterialTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCRecipeProvider(output));
        generator.addProvider(server, (DataProvider)new CCLootTableProvider(output));
        generator.addProvider(server, (DataProvider)CCAdvancementProvider.create(output, provider, helper));
        generator.addProvider(server, (DataProvider)new CCAdvancementModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new CCLootModifierProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new CCItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new CCBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new CCSpriteSourceProvider(output, helper));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CCModelLayers.DEEPER, () -> DeeperModel.createBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(CCModelLayers.DEEPER_HEAD, SkullModel::m_170947_);
        event.registerLayerDefinition(CCModelLayers.DEEPER_ARMOR, () -> DeeperModel.createBodyLayer(new CubeDeformation(2.0f)));
        event.registerLayerDefinition(CCModelLayers.PEEPER, () -> PeeperModel.createBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(CCModelLayers.PEEPER_HEAD, PeeperHeadModel::createHeadLayer);
        event.registerLayerDefinition(CCModelLayers.PEEPER_ARMOR, () -> PeeperModel.createBodyLayer(new CubeDeformation(2.0f)));
        event.registerLayerDefinition(CCModelLayers.MIME, MimeModel::createBodyLayer);
        event.registerLayerDefinition(CCModelLayers.MIME_HEAD, MimeHeadModel::createHeadLayer);
        event.registerLayerDefinition(CCModelLayers.FLY, FlyModel::createBodyLayer);
        event.registerLayerDefinition(CCModelLayers.RAT, RatModel::createBodyLayer);
        event.registerLayerDefinition(CCModelLayers.COPPER_GOLEM, CopperGolemModel::createBodyLayer);
        event.registerLayerDefinition(CCModelLayers.GLARE, GlareModel::createBodyLayer);
        event.registerLayerDefinition(CCModelLayers.TOOLBOX, ToolboxRenderer::createBodyLayer);
        event.registerLayerDefinition(CCModelLayers.LOST_GOAT, LostGoatModel::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CCEntityTypes.DEEPER.get(), DeeperRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.PEEPER.get(), PeeperRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.KUNAI.get(), KunaiRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.MIME.get(), MimeRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.COPPER_GOLEM.get(), CopperGolemRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.OXIDIZED_COPPER_GOLEM.get(), OxidizedCopperGolemRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.BEJEWELED_PEARL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.TMT.get(), TmtRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.BLUNT_ARROW.get(), BluntArrowRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.BLUNT_ARROW.get(), BluntArrowRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.LARGE_ARROW.get(), LargeArrowRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.GLARE.get(), GlareRenderer::new);
        event.registerEntityRenderer((EntityType)CCEntityTypes.LOST_GOAT.get(), LostGoatRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CCBlockEntityTypes.CUPRIC_CAMPFIRE.get(), CampfireRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CCBlockEntityTypes.SKULL.get(), SkullBlockRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CCBlockEntityTypes.TOOLBOX.get(), ToolboxRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerLayers(EntityRenderersEvent.AddLayers event) {
        event.getSkins().forEach(skin -> {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skin);
            renderer.m_115326_((RenderLayer)new RatOnShoulderLayer(renderer, event.getEntityModels()));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : TuningForkItem.getNoteColor(stack), new ItemLike[]{(ItemLike)CCItems.TUNING_FORK.get()});
        event.register((stack, color) -> color > 0 ? -1 : PotionUtils.m_43575_((ItemStack)stack), new ItemLike[]{(ItemLike)CCItems.TETHER_POTION.get()});
        event.register((stack, color) -> color > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{Items.f_151058_});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void createSkullModels(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)CCBlocks.CCSkullTypes.DEEPER, (SkullModelBase)new SkullModel(event.getEntityModelSet().m_171103_(CCModelLayers.DEEPER_HEAD)));
        event.registerSkullModel((SkullBlock.Type)CCBlocks.CCSkullTypes.MIME, (SkullModelBase)new MimeHeadModel(event.getEntityModelSet().m_171103_(CCModelLayers.MIME_HEAD)));
        event.registerSkullModel((SkullBlock.Type)CCBlocks.CCSkullTypes.PEEPER, (SkullModelBase)new PeeperHeadModel(event.getEntityModelSet().m_171103_(CCModelLayers.PEEPER_HEAD)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        if (ModList.get().isLoaded("quark")) {
            event.register(ToolboxTooltips.ToolboxComponent.class, Function.identity());
        }
    }

    private void setupMessages() {
        CHANNEL.registerMessage(0, S2CSpinelBoomMessage.class, S2CSpinelBoomMessage::serialize, S2CSpinelBoomMessage::deserialize, S2CSpinelBoomMessage::handle);
    }
}

