/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.block.CorundumClusterBlock;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class BeaconRedirectionModule
extends ZetaModule {
    private static final TagKey<Block> BEACON_TRANSPARENT = BlockTags.create((ResourceLocation)new ResourceLocation("quark:beacon_transparent"));
    @Config
    public static int horizontalMoveLimit = 64;
    @Config(flag="tinted_glass_dims")
    public static boolean allowTintedGlassTransparency = true;
    @Hint(value="tinted_glass_dims")
    Item tinted_glass = Items.f_151011_;
    public static boolean staticEnabled;
    public static ManualTrigger redirectTrigger;

    @LoadEvent
    public final void register(ZRegister event) {
        redirectTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("redirect_beacon");
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    @LoadEvent
    public void addAdditionalHints(ZGatherHints event) {
        String redirectHint = "beacon_redirect_item";
        String type = "amethyst";
        if (!Quark.ZETA.modules.isEnabled(CorundumModule.class)) {
            event.hintItem((ItemLike)Items.f_151086_, "beacon_redirect_item", new Object[0]);
        } else {
            type = "corundum";
        }
        MutableComponent comp = Component.m_237110_((String)"quark.jei.hint.beacon_redirection", (Object[])new Object[]{Component.m_237115_((String)("quark.jei.hint.beacon_" + type))});
        event.accept((ItemLike)Items.f_42065_, (Component)comp);
    }

    public static int tickBeacon(BeaconBlockEntity beacon, int original) {
        BlockPos beaconPos;
        if (!staticEnabled) {
            return original;
        }
        Level world = beacon.m_58904_();
        BlockPos currPos = beaconPos = beacon.m_58899_();
        int horizontalMoves = horizontalMoveLimit;
        int targetHeight = world.m_6924_(Heightmap.Types.WORLD_SURFACE, beaconPos.m_123341_(), beaconPos.m_123343_());
        boolean broke = false;
        boolean didRedirection = false;
        beacon.f_58649_.clear();
        float[] currColor = new float[]{1.0f, 1.0f, 1.0f};
        float alpha = 1.0f;
        Direction lastDir = null;
        ExtendedBeamSegment currSegment = new ExtendedBeamSegment(Direction.UP, Vec3i.f_123288_, currColor, alpha);
        HashSet<BlockPos> seenPositions = new HashSet<BlockPos>();
        boolean check = true;
        boolean hardColorSet = false;
        while (world.m_46739_(currPos) && horizontalMoves > 0) {
            boolean added;
            if (currSegment.dir == Direction.UP && currSegment.dir != lastDir) {
                int heightmapVal = world.m_6924_(Heightmap.Types.WORLD_SURFACE, currPos.m_123341_(), currPos.m_123343_());
                if (heightmapVal == currPos.m_123342_() + 1) {
                    currSegment.setHeight(heightmapVal + 1000);
                    break;
                }
                lastDir = currSegment.dir;
            }
            currPos = currPos.m_121945_(currSegment.dir);
            horizontalMoves = currSegment.dir.m_122434_().m_122479_() ? --horizontalMoves : horizontalMoveLimit;
            BlockState blockstate = world.m_8055_(currPos);
            Block block = blockstate.m_60734_();
            float[] targetColor = blockstate.getBeaconColorMultiplier((LevelReader)world, currPos, beaconPos);
            float targetAlpha = -1.0f;
            if (allowTintedGlassTransparency && block == Blocks.f_152498_) {
                float f = targetAlpha = alpha < 0.3f ? 0.0f : alpha / 2.0f;
            }
            if (BeaconRedirectionModule.isRedirectingBlock(block)) {
                Direction dir = (Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61372_);
                if (dir == currSegment.dir) {
                    currSegment.m_58719_();
                } else {
                    check = true;
                    beacon.f_58649_.add(currSegment);
                    targetColor = BeaconRedirectionModule.getTargetColor(block);
                    if (targetColor[0] == 1.0f && targetColor[1] == 1.0f && targetColor[2] == 1.0f) {
                        targetColor = currColor;
                    }
                    float[] mixedColor = new float[]{(currColor[0] + targetColor[0] * 3.0f) / 4.0f, (currColor[1] + targetColor[1] * 3.0f) / 4.0f, (currColor[2] + targetColor[2] * 3.0f) / 4.0f};
                    currColor = mixedColor;
                    alpha = 1.0f;
                    didRedirection = true;
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(dir, (Vec3i)currPos.m_121996_((Vec3i)beaconPos), currColor, alpha);
                }
            } else if (targetColor != null || targetAlpha != -1.0f) {
                if (Arrays.equals(targetColor, currColor) && targetAlpha == alpha) {
                    currSegment.m_58719_();
                } else {
                    check = true;
                    beacon.f_58649_.add(currSegment);
                    float[] mixedColor = currColor;
                    if (targetColor != null) {
                        mixedColor = new float[]{(currColor[0] + targetColor[0]) / 2.0f, (currColor[1] + targetColor[1]) / 2.0f, (currColor[2] + targetColor[2]) / 2.0f};
                        if (!hardColorSet) {
                            mixedColor = targetColor;
                            hardColorSet = true;
                        }
                        currColor = mixedColor;
                    }
                    if (targetAlpha != -1.0f) {
                        alpha = targetAlpha;
                    }
                    lastDir = currSegment.dir;
                    currSegment = new ExtendedBeamSegment(currSegment.dir, (Vec3i)currPos.m_121996_((Vec3i)beaconPos), mixedColor, alpha);
                }
            } else {
                boolean bedrock = blockstate.m_204336_(BEACON_TRANSPARENT);
                if (!bedrock && blockstate.m_60739_((BlockGetter)world, currPos) >= 15) {
                    broke = true;
                    break;
                }
                currSegment.m_58719_();
                if (bedrock) continue;
            }
            if (!check || (added = seenPositions.add(currPos))) continue;
            broke = true;
            break;
        }
        if (horizontalMoves == 0 || currPos.m_123342_() <= world.m_141937_()) {
            broke = true;
        }
        String tag = "quark:redirected";
        if (!broke) {
            beacon.f_58649_.add(currSegment);
            beacon.f_58651_ = targetHeight + 1;
        } else {
            beacon.getPersistentData().m_128379_("quark:redirected", false);
            beacon.f_58649_.clear();
            beacon.f_58651_ = targetHeight;
        }
        if (!beacon.getPersistentData().m_128471_("quark:redirected") && didRedirection && !beacon.f_58649_.isEmpty()) {
            beacon.getPersistentData().m_128379_("quark:redirected", true);
            int i = beaconPos.m_123341_();
            int j = beaconPos.m_123342_();
            int k = beaconPos.m_123343_();
            for (ServerPlayer serverplayer : beacon.m_58904_().m_45976_(ServerPlayer.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).m_82377_(10.0, 5.0, 10.0))) {
                redirectTrigger.trigger(serverplayer);
            }
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isRedirectingBlock(Block block) {
        return CorundumModule.staticEnabled ? block instanceof CorundumClusterBlock : block == Blocks.f_152492_;
    }

    private static float[] getTargetColor(Block block) {
        float[] fArray;
        if (block instanceof CorundumClusterBlock) {
            CorundumClusterBlock cc = (CorundumClusterBlock)block;
            fArray = cc.base.colorComponents;
        } else {
            float[] fArray2 = new float[3];
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray = fArray2;
            fArray2[2] = 1.0f;
        }
        return fArray;
    }

    public static class ExtendedBeamSegment
    extends BeaconBlockEntity.BeaconBeamSection {
        public final Direction dir;
        public final Vec3i offset;
        public final float alpha;
        private boolean isTurn = false;

        public ExtendedBeamSegment(Direction dir, Vec3i offset, float[] colorsIn, float alpha) {
            super(colorsIn);
            this.offset = offset;
            this.dir = dir;
            this.alpha = alpha;
        }

        public void makeTurn() {
            this.isTurn = true;
        }

        public boolean isTurn() {
            return this.isTurn;
        }

        public void m_58719_() {
            super.m_58719_();
        }

        public void setHeight(int target) {
            this.f_58716_ = target;
        }
    }
}

