/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.module;

import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.addons.oddities.client.render.entity.TotemOfHoldingRenderer;
import org.violetmoon.quark.addons.oddities.entity.TotemOfHoldingEntity;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tweaks.compat.TotemOfHoldingCuriosCompat;
import org.violetmoon.zeta.client.event.load.ZAddModels;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDrops;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="oddities")
public class TotemOfHoldingModule
extends ZetaModule {
    private static final String TAG_LAST_TOTEM = "quark:lastTotemOfHolding";
    private static final String TAG_DEATH_X = "quark:deathX";
    private static final String TAG_DEATH_Z = "quark:deathZ";
    private static final String TAG_DEATH_DIM = "quark:deathDim";
    public static EntityType<TotemOfHoldingEntity> totemType;
    @Config(description="Set this to false to remove the behaviour where totems destroy themselves if the player dies again.")
    public static boolean darkSoulsMode;
    @Config(name="Spawn Totem on PVP Kill", description="Totem will always spawn if the player killer is themselves.")
    public static boolean enableOnPK;
    @Config(description="Set this to true to make it so that if a totem is destroyed, the items it holds are destroyed alongside it rather than dropped")
    public static boolean destroyLostItems;
    @Config(description="Set this to false to only allow the owner of a totem to collect its items rather than any player")
    public static boolean allowAnyoneToCollect;

    @LoadEvent
    public final void register(ZRegister event) {
        totemType = EntityType.Builder.m_20704_(TotemOfHoldingEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 1.0f).m_20717_(128).m_20719_().setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new TotemOfHoldingEntity((EntityType<? extends TotemOfHoldingEntity>)totemType, (Level)world)).m_20712_("totem");
        Quark.ZETA.registry.register(totemType, "totem", Registries.f_256939_);
    }

    @PlayEvent
    public void onPlayerDrops(ZLivingDrops.Lowest event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Collection drops = event.getDrops();
        if (!(event.isCanceled() || !enableOnPK && event.getSource().m_7639_() instanceof Player && entity != event.getSource().m_7639_())) {
            CompoundTag data = player.getPersistentData();
            CompoundTag persistent = data.m_128469_("PlayerPersisted");
            if (!drops.isEmpty()) {
                TotemOfHoldingEntity totem = new TotemOfHoldingEntity(totemType, player.m_9236_());
                totem.m_6034_(player.m_20185_(), Math.max((double)(player.m_9236_().m_141937_() + 3), player.m_20186_() + 1.0), player.m_20189_());
                totem.setOwner(player);
                totem.m_6593_(player.m_5446_());
                drops.stream().filter(Objects::nonNull).map(ItemEntity::m_32055_).filter(stack -> !stack.m_41619_()).forEach(totem::addItem);
                if (this.zeta().isModLoaded("curios")) {
                    TotemOfHoldingCuriosCompat.saveCurios(player, totem);
                }
                if (!player.m_9236_().f_46443_) {
                    player.m_9236_().m_7967_((Entity)totem);
                }
                persistent.m_128359_(TAG_LAST_TOTEM, totem.m_20148_().toString());
                event.setCanceled(true);
            } else {
                persistent.m_128359_(TAG_LAST_TOTEM, "");
            }
            BlockPos pos = player.m_20183_();
            persistent.m_128405_(TAG_DEATH_X, pos.m_123341_());
            persistent.m_128405_(TAG_DEATH_Z, pos.m_123343_());
            persistent.m_128359_(TAG_DEATH_DIM, player.m_9236_().m_46472_().m_135782_().toString());
            if (!data.m_128441_("PlayerPersisted")) {
                data.m_128365_("PlayerPersisted", (Tag)persistent);
            }
        }
    }

    public static String getTotemUUID(Player player) {
        CompoundTag cmp = player.getPersistentData().m_128469_("PlayerPersisted");
        if (cmp.m_128441_(TAG_LAST_TOTEM)) {
            return cmp.m_128461_(TAG_LAST_TOTEM);
        }
        return "";
    }

    static {
        darkSoulsMode = true;
        enableOnPK = false;
        destroyLostItems = false;
        allowAnyoneToCollect = true;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends TotemOfHoldingModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.m_174036_((EntityType)totemType, TotemOfHoldingRenderer::new);
        }

        @LoadEvent
        public void registerAdditionalModels(ZAddModels event) {
            event.register((ResourceLocation)new ModelResourceLocation("quark", "extra/totem_of_holding", "inventory"));
        }
    }
}

