/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.customitems.swords.alexscaves;

import com.craisinlord.EffectRegistry;
import com.craisinlord.IntegratedSimplySwordsCommon;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class PolarizerSwordItem
extends UniqueSwordItem {
    public PolarizerSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        CompoundTag tag = stack.m_41784_();
        boolean pushMode = tag.m_128471_("PushMode");
        if (!attacker.m_9236_().m_5776_()) {
            if (pushMode) {
                double knockbackStrength = IntegratedSimplySwordsCommon.alexscavesConfig.POLARIZER_KNOCKBACK_STRENGTH;
                double dx = attacker.m_20185_() - target.m_20185_();
                double dz = attacker.m_20189_() - target.m_20189_();
                target.m_147240_(knockbackStrength, dx, dz);
            } else if (attacker instanceof Player) {
                Player player = (Player)attacker;
                if (player.m_36335_().m_41519_(stack.m_41720_())) {
                    return super.m_7579_(stack, target, attacker);
                }
                HelperMethods.playHitSounds((LivingEntity)attacker, (LivingEntity)target);
                target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.POLARIZED.get(), 120, 1), (Entity)attacker);
                attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_IMPACT_01.get(), attacker.m_5720_(), 0.5f, 1.2f);
                player.m_36335_().m_41524_(stack.m_41720_(), IntegratedSimplySwordsCommon.alexscavesConfig.POLARIZER_COOLDOWN);
            } else {
                HelperMethods.playHitSounds((LivingEntity)attacker, (LivingEntity)target);
                target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.POLARIZED.get(), 120, 1), (Entity)attacker);
                attacker.m_9236_().m_6269_(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_IMPACT_01.get(), attacker.m_5720_(), 0.5f, 1.2f);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (user.m_6144_()) {
            if (!world.m_5776_()) {
                CompoundTag tag = stack.m_41784_();
                boolean currentMode = tag.m_128471_("PushMode");
                boolean newMode = !currentMode;
                tag.m_128379_("PushMode", newMode);
                String modeName = newMode ? "Push" : "Pull";
                ChatFormatting messageColor = newMode ? ChatFormatting.RED : ChatFormatting.BLUE;
                user.m_5661_((Component)Component.m_237113_((String)("Switched mode to " + modeName)).m_130940_(messageColor), false);
                world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), (SoundEvent)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.m_5720_(), 0.5f, 1.0f);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style ABILITY = HelperMethods.getStyle((String)"ability");
        Style TEXT = HelperMethods.getStyle((String)"text");
        Style SHIFT_RIGHT_CLICK = HelperMethods.getStyle((String)"rightclick");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.integrated_simply_swords.shift_right_click").m_6270_(SHIFT_RIGHT_CLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.integrated_simply_swords.alexscaves.polarizer.tooltip1").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.integrated_simply_swords.alexscaves.polarizer.tooltip2").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.integrated_simply_swords.alexscaves.polarizer.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.integrated_simply_swords.alexscaves.polarizer.tooltip4").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.integrated_simply_swords.alexscaves.polarizer.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.integrated_simply_swords.alexscaves.polarizer.tooltip6").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

