/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import net.minecraft.network.chat.TextColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextColor.class})
public class TextColorMixin {
    @Inject(method={"parseColor"}, at={@At(value="HEAD")}, cancellable=true)
    private static void parseColor(String colorString, CallbackInfoReturnable<TextColor> info) {
        if (!colorString.startsWith("#")) {
            return;
        }
        try {
            int i = Integer.parseUnsignedInt(colorString.substring(1), 16);
            info.setReturnValue((Object)TextColor.m_131266_((int)i));
            info.cancel();
        }
        catch (NumberFormatException numberformatexception) {
            info.setReturnValue(null);
            info.cancel();
        }
    }
}

