/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import com.unascribed.fabrication.Agnos;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class FabricationEventsClient {
    private static final Set<Agnos.TooltipRenderCallback> tooltipRender = new HashSet<Agnos.TooltipRenderCallback>();
    private static final Set<Agnos.HudRenderCallback> hudRender = new HashSet<Agnos.HudRenderCallback>();
    private static KeyMapping[] keybindings = null;

    public static void addTooltip(Agnos.TooltipRenderCallback c) {
        tooltipRender.add(c);
    }

    public static void addHud(Agnos.HudRenderCallback c) {
        hudRender.add(c);
    }

    public static void addKeybind(KeyMapping c) {
        if (keybindings == null) {
            keybindings = new KeyMapping[]{c};
            return;
        }
        for (KeyMapping e : keybindings) {
            if (e != c) continue;
            return;
        }
        KeyMapping[] nk = new KeyMapping[keybindings.length + 1];
        System.arraycopy(keybindings, 0, nk, 0, keybindings.length);
        nk[FabricationEventsClient.keybindings.length] = c;
        keybindings = nk;
    }

    public static void tooltip(ItemStack stack, List<Component> lines) {
        for (Agnos.TooltipRenderCallback c : tooltipRender) {
            c.render(stack, lines);
        }
    }

    public static void hud(GuiGraphics drawContext, float tickDelta) {
        for (Agnos.HudRenderCallback c : hudRender) {
            c.render(drawContext, tickDelta);
        }
    }

    public static KeyMapping[] keys(KeyMapping[] in) {
        if (in == null) {
            return null;
        }
        if (keybindings == null) {
            return in;
        }
        byte[] cnew = new byte[keybindings.length];
        int cursor = 0;
        block0: for (int i = 0; i < keybindings.length; i = (int)((byte)(i + 1))) {
            KeyMapping ke = keybindings[i];
            KeyMapping[] keyMappingArray = in;
            int n = keyMappingArray.length;
            for (int j = 0; j < n; ++j) {
                KeyMapping kin = keyMappingArray[j];
                if (ke == kin) continue block0;
            }
            cnew[cursor++] = i;
        }
        if (cursor == 0) {
            return in;
        }
        KeyMapping[] nin = new KeyMapping[in.length + cursor];
        System.arraycopy(in, 0, nin, 0, in.length);
        for (byte i : cnew) {
            nin[in.length + --cursor] = keybindings[i];
        }
        return nin;
    }
}

