/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.f_balance.chest_pigs;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.FailOn;
import com.unascribed.fabrication.support.injection.FabInject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(configAvailable="*.chest_pigs")
@FailOn(modLoaded={"haulinghog"})
@Mixin(value={Pig.class}, priority=1001)
public abstract class MixinPigEntity
extends Entity {
    @Unique
    private SimpleContainer fabrication$chestPig = null;

    public MixinPigEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @FabInject(method={"dropInventory()V"}, at={@At(value="HEAD")})
    protected void dropInventory(CallbackInfo info) {
        if (this.fabrication$chestPig != null) {
            switch (this.fabrication$chestPig.m_6643_()) {
                case 53: {
                    this.m_19998_((ItemLike)Items.f_42009_);
                }
                case 27: {
                    this.m_19998_((ItemLike)Items.f_42009_);
                    break;
                }
                case 0: {
                    this.m_19998_((ItemLike)Items.f_42108_);
                }
            }
            for (ItemStack item : this.fabrication$chestPig.m_19195_()) {
                this.m_19983_(item);
            }
        }
    }

    @FabInject(method={"interactMob(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void interact(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
        if (!FabConf.isEnabled("*.chest_pigs")) {
            return;
        }
        if (player.m_6144_()) {
            Level world = this.m_9236_();
            if (this.fabrication$chestPig == null) {
                ItemStack stack = player.m_150109_().m_36056_();
                boolean isChest = stack.m_41720_().equals(Items.f_42009_);
                if (isChest || stack.m_41720_().equals(Items.f_42108_)) {
                    info.setReturnValue((Object)InteractionResult.SUCCESS);
                    stack.m_41774_(1);
                    this.fabrication$chestPig = new SimpleContainer(isChest ? 27 : 0);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_11748_, SoundSource.NEUTRAL, 0.2f, 0.4f);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_12233_, SoundSource.NEUTRAL, 0.7f, 0.1f);
                }
            } else {
                info.setReturnValue((Object)InteractionResult.SUCCESS);
                int invSize = this.fabrication$chestPig.m_6643_();
                switch (invSize) {
                    case 0: {
                        player.m_5893_((MenuProvider)new SimpleMenuProvider(new MenuConstructor(){

                            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                                return ChestMenu.m_39237_((int)syncId, (Inventory)inv, (Container)player.m_36327_());
                            }
                        }, (Component)Component.m_237115_((String)"container.enderchest")));
                        break;
                    }
                    case 27: {
                        ItemStack stack = player.m_150109_().m_36056_();
                        if (stack.m_41720_().equals(Items.f_42009_)) {
                            stack.m_41774_(1);
                            SimpleContainer temp = new SimpleContainer(54);
                            for (ItemStack item : this.fabrication$chestPig.m_19195_()) {
                                temp.m_19173_(item);
                            }
                            this.fabrication$chestPig = temp;
                            world.m_5594_(null, this.m_20183_(), SoundEvents.f_11748_, SoundSource.NEUTRAL, 0.2f, 0.4f);
                            world.m_5594_(null, this.m_20183_(), SoundEvents.f_12233_, SoundSource.NEUTRAL, 0.7f, 0.1f);
                            return;
                        }
                        player.m_5893_((MenuProvider)new SimpleMenuProvider(new MenuConstructor(){

                            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                                return ChestMenu.m_39237_((int)syncId, (Inventory)inv, (Container)MixinPigEntity.this.fabrication$chestPig);
                            }
                        }, (Component)Component.m_237115_((String)"container.chest")));
                        break;
                    }
                    case 54: {
                        player.m_5893_((MenuProvider)new SimpleMenuProvider(new MenuConstructor(){

                            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                                return ChestMenu.m_39246_((int)syncId, (Inventory)inv, (Container)MixinPigEntity.this.fabrication$chestPig);
                            }
                        }, (Component)Component.m_237115_((String)"container.chest")));
                    }
                }
            }
        }
    }

    @FabInject(method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="HEAD")})
    public void writeCustomDataToTag(CompoundTag tags, CallbackInfo info) {
        if (this.fabrication$chestPig != null) {
            CompoundTag tag = new CompoundTag();
            tags.m_128344_("fabrication$chestPigs$size", (byte)this.fabrication$chestPig.m_6643_());
            for (byte i = 0; i < this.fabrication$chestPig.m_6643_(); i = (byte)(i + 1)) {
                CompoundTag tagi = new CompoundTag();
                this.fabrication$chestPig.m_8020_((int)i).m_41739_(tagi);
                tag.m_128365_("" + i, (Tag)tagi);
            }
            tags.m_128365_("fabrication$chestPigs$inv", (Tag)tag);
        }
    }

    @FabInject(method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="HEAD")})
    public void readCustomDataFromTag(CompoundTag tags, CallbackInfo info) {
        CompoundTag tag = tags.m_128469_("fabrication$chestPigs$inv");
        if (tag == null || !tags.m_128441_("fabrication$chestPigs$size")) {
            return;
        }
        byte size = tags.m_128445_("fabrication$chestPigs$size");
        switch (size) {
            case 0: {
                this.fabrication$chestPig = new SimpleContainer(0);
                break;
            }
            case 27: 
            case 54: {
                this.fabrication$chestPig = new SimpleContainer((int)size);
                for (byte i = 0; i < size; i = (byte)(i + 1)) {
                    this.fabrication$chestPig.m_6836_((int)i, ItemStack.m_41712_((CompoundTag)tag.m_128469_("" + i)));
                }
                break;
            }
            default: {
                this.fabrication$chestPig = null;
            }
        }
    }
}

