/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.c_tweaks.scares_creepers;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(configAvailable="*.scares_creepers")
@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    private static final Predicate<Player> fabrication$scaresCreepersPredicate = ConfigPredicates.getFinalPredicate("*.scares_creepers");

    protected MixinLivingEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
    }

    @FabInject(at={@At(value="HEAD")}, method={"canTarget(Lnet/minecraft/entity/LivingEntity;)Z"}, cancellable=true)
    public void canTarget(LivingEntity other, CallbackInfoReturnable<Boolean> ci) {
        if (!FabConf.isEnabled("*.scares_creepers") || !(other instanceof Player)) {
            return;
        }
        MixinLivingEntity self = this;
        if (self instanceof Creeper && fabrication$scaresCreepersPredicate.test((Player)other)) {
            ci.setReturnValue((Object)false);
        }
    }
}

