/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.c_tweaks.no_trample;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(anyConfigAvailable={"*.feather_falling_no_trample", "*.no_trample"})
@Mixin(value={FarmBlock.class})
public abstract class MixinFarmBlock
extends Block {
    private static final Predicate<LivingEntity> fabrication$noTramplePredicate = ConfigPredicates.getFinalPredicate("*.no_trample");

    public MixinFarmBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @FabInject(method={"onLandedUpon(Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onLandedUpon(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance, CallbackInfo ci) {
        if (!FabConf.isAnyEnabled("*.no_trample")) {
            return;
        }
        if (entity instanceof LivingEntity && fabrication$noTramplePredicate.test((LivingEntity)entity)) {
            super.m_142072_(world, state, pos, entity, fallDistance);
            ci.cancel();
        }
    }
}

