/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.c_tweaks.invisible_to_mobs;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.ConfigPredicates;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.ModifyReturn;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import org.spongepowered.asm.mixin.Mixin;

@EligibleIf(anyConfigAvailable={"*.no_phantoms", "*.invisible_to_mobs"})
@Mixin(value={PhantomSpawner.class})
public class MixinPhantomSpawner {
    private static final Predicate<Player> fabrication$noPhantomsPredicate = ConfigPredicates.getFinalPredicate("*.no_phantoms");
    private static final Predicate<Player> fabrication$invisMobsPredicate = ConfigPredicates.getFinalPredicate("*.invisible_to_mobs");

    @ModifyReturn(method={"spawn(Lnet/minecraft/server/world/ServerWorld;ZZ)I"}, target={"Lnet/minecraft/server/network/ServerPlayerEntity;isSpectator()Z"})
    private static boolean fabrication$InvisTaggablePlayersIsSpectator(boolean original, Player subject) {
        if (FabConf.isEnabled("*.invisible_to_mobs") && fabrication$invisMobsPredicate.test(subject)) {
            return true;
        }
        if (FabConf.isEnabled("*.no_phantoms") && fabrication$noPhantomsPredicate.test(subject)) {
            return true;
        }
        return original;
    }
}

