/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.logic;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.loaders.LoaderClassicBlockDrops;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MipmapGenerator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.ARBCopyImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class WoinaDrops {
    public static float curTimer;
    private static AbstractTexture mippedBlocks;
    public static boolean mippedBlocksInvalid;

    public static int modifyOverlay(int hash, int overlay) {
        if (FabConf.isEnabled("*.blinking_drops")) {
            return OverlayTexture.m_118090_((float)(Math.max(0.0f, Mth.m_14031_((float)((curTimer + (float)(hash % 2000)) / 5.3f))) * 0.7f), (boolean)false);
        }
        return overlay;
    }

    public static void interceptRender(ItemRenderer subject, final ItemStack stack, ItemDisplayContext renderMode, boolean leftHanded, final PoseStack matrices, MultiBufferSource vertexConsumers, final int light, int overlay, BakedModel model) {
        if (FabConf.isEnabled("*.classic_block_drops") && stack.m_41720_() instanceof BlockItem && model instanceof SimpleBakedModel && model.m_7539_()) {
            matrices.m_85836_();
            model.m_7442_().m_269404_(renderMode).m_111763_(leftHanded, matrices);
            matrices.m_85837_(-0.5, -0.5, -0.5);
            if (LoaderClassicBlockDrops.isSafe(((BlockItem)stack.m_41720_()).m_40614_())) {
                RandomSource r = RandomSource.m_216327_();
                long seed = 42L;
                RenderType layer = ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true);
                final VertexConsumer vertices = vertexConsumers.m_6299_(layer);
                final int overlayf = overlay;
                for (Direction dir : Direction.values()) {
                    r.m_188584_(seed);
                    model.m_213637_(null, dir, r).forEach(new Consumer<BakedQuad>(){

                        @Override
                        public void accept(BakedQuad q) {
                            WoinaDrops.drawExaggeratedQuad(stack, matrices, vertices, q, light, overlayf);
                        }
                    });
                }
                r.m_188584_(seed);
                model.m_213637_(null, null, r).forEach(new Consumer<BakedQuad>(){

                    @Override
                    public void accept(BakedQuad q) {
                        WoinaDrops.drawExaggeratedQuad(stack, matrices, vertices, q, light, overlayf);
                    }
                });
            } else {
                RenderType defLayer;
                if (mippedBlocks == null || mippedBlocksInvalid) {
                    mippedBlocksInvalid = false;
                    mippedBlocks = new AbstractTexture(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void m_6704_(ResourceManager manager) throws IOException {
                            block9: {
                                this.m_117964_();
                                TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(new ResourceLocation("textures/atlas/blocks.png"));
                                RenderSystem.bindTexture((int)atlas.m_117963_());
                                int maxLevel = GL11.glGetTexParameteri((int)3553, (int)33085);
                                if (maxLevel == 0 || !GL.getCapabilities().GL_ARB_copy_image) {
                                    int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                                    int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                                    ByteBuffer dest = MemoryUtil.memAlloc((int)(w * h * 4));
                                    try {
                                        GL11.glGetTexImage((int)3553, (int)0, (int)NativeImage.Format.RGBA.m_85170_(), (int)5121, (long)MemoryUtil.memAddress((ByteBuffer)dest));
                                    }
                                    catch (Error | RuntimeException e) {
                                        MemoryUtil.memFree((Buffer)dest);
                                        throw e;
                                    }
                                    try (NativeImage img = FabRefl.Client.NativeImage_new(NativeImage.Format.RGBA, w, h, false, MemoryUtil.memAddress((ByteBuffer)dest));
                                         NativeImage mipped = MipmapGenerator.m_246246_((NativeImage[])new NativeImage[]{img}, (int)1)[1];){
                                        TextureUtil.prepareImage((int)this.m_117963_(), (int)mipped.m_84982_(), (int)mipped.m_85084_());
                                        RenderSystem.bindTexture((int)this.m_117963_());
                                        mipped.m_85040_(0, 0, 0, true);
                                        break block9;
                                    }
                                }
                                int w = GL11.glGetTexLevelParameteri((int)3553, (int)1, (int)4096);
                                int h = GL11.glGetTexLevelParameteri((int)3553, (int)1, (int)4097);
                                TextureUtil.prepareImage((int)this.m_117963_(), (int)w, (int)h);
                                ARBCopyImage.glCopyImageSubData((int)atlas.m_117963_(), (int)3553, (int)1, (int)0, (int)0, (int)0, (int)this.m_117963_(), (int)3553, (int)0, (int)0, (int)0, (int)0, (int)w, (int)h, (int)1);
                            }
                        }
                    };
                    Minecraft.m_91087_().m_91097_().m_118495_(new ResourceLocation("fabrication", "textures/atlas/blocks-mip.png"), mippedBlocks);
                }
                RenderType layer = (defLayer = ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true)) == Sheets.m_110790_() ? RenderType.m_110452_((ResourceLocation)new ResourceLocation("fabrication", "textures/atlas/blocks-mip.png")) : RenderType.m_110473_((ResourceLocation)new ResourceLocation("fabrication", "textures/atlas/blocks-mip.png"));
                VertexConsumer vertices = vertexConsumers.m_6299_(layer);
                FabRefl.Client.ItemRenderer_renderBakedItemModel(subject, model, stack, light, overlay, matrices, vertices);
            }
            matrices.m_85849_();
            return;
        }
        subject.m_115143_(stack, renderMode, leftHanded, matrices, vertexConsumers, light, overlay, model);
    }

    private static void drawExaggeratedQuad(ItemStack is, PoseStack matrices, VertexConsumer vertices, BakedQuad quad, int light, int overlay) {
        boolean isProbablyGrass = false;
        int packedColor = -1;
        if (quad.m_111304_()) {
            packedColor = FabRefl.Client.getItemColors(Minecraft.m_91087_()).m_92676_(is, quad.m_111305_());
            Block b = ((BlockItem)is.m_41720_()).m_40614_();
            SoundType sg = b.m_49966_().m_60827_();
            isProbablyGrass = sg == SoundType.f_56740_ || sg == SoundType.f_56739_ && b.m_284356_() == MapColor.f_283762_;
        }
        float tintR = (float)(packedColor >> 16 & 0xFF) / 255.0f;
        float tintG = (float)(packedColor >> 8 & 0xFF) / 255.0f;
        float tintB = (float)(packedColor & 0xFF) / 255.0f;
        PoseStack.Pose ent = matrices.m_85850_();
        int[] data = quad.m_111303_();
        Vec3i faceVec = quad.m_111306_().m_122436_();
        Vector3f normal = new Vector3f((float)faceVec.m_123341_(), (float)faceVec.m_123342_(), (float)faceVec.m_123343_());
        Vector4f pos = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f mat = ent.m_252922_();
        normal.mul((Matrix3fc)ent.m_252943_());
        int j = data.length / 8;
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer buf = stack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer iBuf = buf.asIntBuffer();
            float minU = Float.POSITIVE_INFINITY;
            float maxU = Float.NEGATIVE_INFINITY;
            float minV = Float.POSITIVE_INFINITY;
            float maxV = Float.NEGATIVE_INFINITY;
            for (int pass = 0; pass < 2; ++pass) {
                for (int i = 0; i < j; ++i) {
                    ((Buffer)iBuf).clear();
                    iBuf.put(data, i * 8, 8);
                    float u = buf.getFloat(16);
                    float v = buf.getFloat(20);
                    if (pass == 0) {
                        minU = Math.min(minU, u);
                        maxU = Math.max(maxU, u);
                        minV = Math.min(minV, v);
                        maxV = Math.max(maxV, v);
                        continue;
                    }
                    if (pass != 1) continue;
                    float x = buf.getFloat(0);
                    float y = buf.getFloat(4);
                    float z = buf.getFloat(8);
                    float r = (float)(buf.get(12) & 0xFF) / 255.0f * tintR;
                    float g = (float)(buf.get(13) & 0xFF) / 255.0f * tintG;
                    float b = (float)(buf.get(14) & 0xFF) / 255.0f * tintB;
                    pos.set(x, y, z, 1.0f);
                    pos.mul((Matrix4fc)mat);
                    float uSize = maxU - minU;
                    float vSize = maxV - minV;
                    if (u == minU) {
                        u = minU + uSize * 0.25f;
                    } else if (u == maxU) {
                        u = minU + uSize * 0.75f;
                    }
                    if (v == minV) {
                        v = minV + vSize * ((float)(isProbablyGrass ? 1 : 4) / 16.0f);
                    } else if (v == maxV) {
                        v = minV + vSize * ((float)(isProbablyGrass ? 9 : 12) / 16.0f);
                    }
                    vertices.m_5954_(pos.x, pos.y, pos.z, r, g, b, 1.0f, u, v, overlay, light, normal.x, normal.y, normal.z);
                }
            }
        }
    }

    static {
        mippedBlocksInvalid = true;
    }
}

