/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.logic;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.fabrication.FabLog;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class LegacyIDs {
    private static final Int2ObjectOpenHashMap<Item> data = new Int2ObjectOpenHashMap();
    private static final Int2ObjectOpenHashMap<ResourceLocation> data_id = new Int2ObjectOpenHashMap();

    public static Item lookup(int id, int meta) {
        return (Item)data.get(id << 16 | meta);
    }

    public static ResourceLocation lookup_id(int id, int meta) {
        return (ResourceLocation)data_id.get(id << 16 | meta);
    }

    static {
        try {
            JsonObject obj = (JsonObject)new Gson().fromJson(Resources.toString((URL)LegacyIDs.class.getClassLoader().getResource("legacy_ids.json"), (Charset)Charsets.UTF_8), JsonObject.class);
            for (Map.Entry en : obj.entrySet()) {
                if (((String)en.getKey()).equals("_comment")) continue;
                int colon = ((String)en.getKey()).indexOf(58);
                int id = Integer.parseInt(((String)en.getKey()).substring(0, colon));
                int meta = Integer.parseInt(((String)en.getKey()).substring(colon + 1));
                int key = id << 16 | meta;
                ResourceLocation ident = new ResourceLocation(((JsonElement)en.getValue()).getAsString());
                data.put(key, (Object)((Item)BuiltInRegistries.f_257033_.m_7745_(ident)));
                data_id.put(key, (Object)ident);
            }
        }
        catch (Throwable t) {
            FabLog.warn("Failed to load legacy IDs", t);
        }
    }
}

