/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.logic;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CanHitUtil {
    public static boolean canHit(ListTag list, Entity entity) {
        if (list == null) {
            return true;
        }
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object id;
                String s = list.m_128778_(i);
                if (s.contains("-")) {
                    try {
                        UUID id2 = UUID.fromString(s);
                        if (!entity.m_20148_().equals(id2)) continue;
                        return true;
                    }
                    catch (IllegalArgumentException id2) {
                        // empty catch block
                    }
                }
                if (s.startsWith("@")) {
                    EntitySelector ep = new EntitySelectorParser(new StringReader(s), true).m_121377_();
                    Predicate<Entity> predicate = FabRefl.getBasePredicate(ep);
                    if (!predicate.test(entity)) continue;
                    return true;
                }
                boolean needed = true;
                if (s.startsWith("!")) {
                    s = s.substring(1);
                    needed = false;
                }
                Object object = id = s.contains(":") ? s : "minecraft:" + s;
                if (EntityType.m_20613_((EntityType)entity.m_6095_()).toString().equals(id) != needed) continue;
                return true;
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return false;
    }

    public static boolean canHit(ItemStack stack, Entity entity) {
        if (stack.m_41782_() && stack.m_41783_().m_128425_("CanHit", 9)) {
            ListTag canhit = stack.m_41783_().m_128437_("CanHit", 8);
            return CanHitUtil.canHit(canhit, entity);
        }
        return true;
    }

    public static boolean isExempt(Entity shooter) {
        if (shooter instanceof Player) {
            Player p = (Player)shooter;
            return p.m_150110_().f_35937_ || !FabConf.isEnabled("*.adventure_tags_in_survival") && p.m_36326_();
        }
        return false;
    }
}

