/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.util.Resolvable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class LoaderGearComponents
implements ConfigLoader {
    public static DoubleSupplier dropRate = () -> 0.75;
    public static int guaranteedIngots = 1;
    public static boolean ignoreVanishing = true;
    public static int cheat = 1;
    public static final Map<String, MaterialData> materials = Maps.newHashMap();
    public static final Multimap<Resolvable<Item>, ItemMaterialValue> items = ArrayListMultimap.create();
    private static final RandomSource rand = RandomSource.m_216327_();
    private static final Splitter SPACE_SPLITTER = Splitter.on((char)' ');
    private static final Pattern MATERIAL_VALUE_PATTERN = Pattern.compile("^([0-9]+(?:\\.[0-9]+)?)(.*)$");

    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        dropRate = () -> 0.75;
        materials.clear();
        items.clear();
        double dropRateMin = config.getDouble("@options.drop_rate_min").orElse(75.0) / 100.0;
        double dropRateMid = config.getDouble("@options.drop_rate_mid").orElse(75.0) / 100.0;
        double dropRateMax = config.getDouble("@options.drop_rate_max").orElse(75.0) / 100.0;
        boolean dropRateUniform = config.getBoolean("@options.drop_rate_uniform").orElse(false);
        if (dropRateMin == dropRateMid && dropRateMid == dropRateMax) {
            double rate = dropRateMid;
            dropRate = () -> rate;
        } else if (dropRateUniform) {
            min = dropRateMin;
            double max = dropRateMax;
            dropRate = () -> min + rand.m_188500_() * (max - min);
        } else {
            min = dropRateMin;
            double mid = dropRateMid;
            double max = dropRateMax;
            dropRate = () -> {
                double value = rand.m_188500_() - rand.m_188500_();
                if (value < 0.0) {
                    return mid + value * (mid - min);
                }
                if (value > 0.0) {
                    return mid + value * (max - mid);
                }
                return 0.0;
            };
        }
        Optional<String> guaranteedIngotsStr = config.get("@options.guaranteed_ingots");
        if (guaranteedIngotsStr.isPresent()) {
            if ("*".equals(guaranteedIngotsStr.get())) {
                guaranteedIngots = Integer.MAX_VALUE;
            } else {
                Integer i = Ints.tryParse((String)guaranteedIngotsStr.get());
                if (i == null) {
                    FabLog.warn("@options.guaranteed_ingots must be * or a whole number (got " + guaranteedIngotsStr.get() + ") at " + config.getBlame("@options.guaranteed_ingots"));
                    guaranteedIngots = 1;
                } else {
                    guaranteedIngots = i;
                }
            }
        } else {
            guaranteedIngots = 1;
        }
        ignoreVanishing = config.getBoolean("@options.ignore_vanishing").orElse(false);
        cheat = config.getInt("@options.cheat").orElse(1);
        for (String k : config.keySet()) {
            String v = config.get(k).get();
            if (k.startsWith("@materials.")) {
                String id = k.substring(11);
                String namespace = id.contains(":") ? id.substring(0, id.indexOf(58)) : "minecraft";
                String name = id.substring(id.indexOf(58) + 1);
                if (name.equals("xp")) {
                    FabLog.warn(k + " is not a valid material definition (xp is a reserved name) at " + config.getBlame(k));
                    continue;
                }
                List split = SPACE_SPLITTER.splitToList((CharSequence)v);
                if (split.size() < 2) {
                    FabLog.warn(k + " is not a valid material definition (got " + v + " which only has " + split.size() + " elements, need 2 or 3) at " + config.getBlame(k));
                    continue;
                }
                if (split.size() > 3) {
                    FabLog.warn(k + " is not a valid material definition (got " + v + " which has " + split.size() + " elements, need 2 or 3) at " + config.getBlame(k));
                    continue;
                }
                int npi = Integer.parseInt((String)split.get(0));
                String nuggetId = (String)split.get(1);
                String ingotId = split.size() >= 3 ? (String)split.get(2) : null;
                Supplier<Item> nuggetGetter = LoaderGearComponents.resolver(namespace, nuggetId);
                Supplier<Item> ingotGetter = LoaderGearComponents.resolver(namespace, ingotId);
                materials.put(name, new MaterialData(npi, nuggetGetter, ingotGetter));
                continue;
            }
            if (k.startsWith("@")) continue;
            Resolvable r = Resolvable.of(new ResourceLocation(k), BuiltInRegistries.f_257033_);
            for (String s : SPACE_SPLITTER.split((CharSequence)v)) {
                Matcher m = MATERIAL_VALUE_PATTERN.matcher(s);
                if (m.matches()) {
                    double amt = Double.parseDouble(m.group(1));
                    String mat = m.group(2);
                    boolean ench = false;
                    boolean idr = false;
                    for (int i = 0; i < 2; ++i) {
                        if (mat.endsWith("!")) {
                            idr = true;
                            mat = mat.substring(0, mat.length() - 1);
                        }
                        if (!mat.endsWith("*")) continue;
                        ench = true;
                        mat = mat.substring(0, mat.length() - 1);
                    }
                    items.put(r, (Object)new ItemMaterialValue(amt, mat, idr, ench));
                    continue;
                }
                FabLog.warn(k + " is not a valid material value definition (got " + v + ") at " + config.getBlame(k));
            }
        }
        for (Map.Entry en : items.entries()) {
            if (materials.containsKey(((ItemMaterialValue)en.getValue()).materialName) || "xp".equals(((ItemMaterialValue)en.getValue()).materialName)) continue;
            FabLog.warn("Unknown material name " + ((ItemMaterialValue)en.getValue()).materialName + " in drops for item " + String.valueOf(((Resolvable)en.getKey()).getId()));
        }
    }

    private static Supplier<Item> resolver(String namespace, String id) {
        if (id == null) {
            return () -> null;
        }
        if (id.startsWith("#")) {
            return LoaderGearComponents.tagResolver(FabricationMod.createIdWithCustomDefault(namespace, id.substring(1)));
        }
        return Resolvable.of(FabricationMod.createIdWithCustomDefault(namespace, id), BuiltInRegistries.f_257033_)::getOrNull;
    }

    private static Supplier<Item> tagResolver(ResourceLocation id) {
        return () -> {
            TagKey itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)id);
            if (BuiltInRegistries.f_257033_.m_203431_(itemTag).isPresent()) {
                return BuiltInRegistries.f_257033_.m_203431_(itemTag).flatMap(items -> items.m_213653_(rand)).map(Holder::m_203334_).orElse(null);
            }
            TagKey blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)id);
            if (BuiltInRegistries.f_256975_.m_203431_(blockTag).isPresent()) {
                return BuiltInRegistries.f_256975_.m_203431_(blockTag).flatMap(blocks -> blocks.m_213653_(rand)).map(blockEntry -> ((Block)blockEntry.m_203334_()).m_5456_()).orElse(null);
            }
            return null;
        };
    }

    @Override
    public String getConfigName() {
        return "gear_components";
    }

    public static final class MaterialData {
        public final int nuggetsPerIngot;
        public final Supplier<Item> nuggetGetter;
        public final Supplier<Item> ingotGetter;

        public MaterialData(int nuggetsPerIngot, Supplier<Item> nuggetGetter, Supplier<Item> ingotGetter) {
            this.nuggetsPerIngot = nuggetsPerIngot;
            this.nuggetGetter = nuggetGetter;
            this.ingotGetter = ingotGetter;
        }
    }

    public static final class ItemMaterialValue {
        public final double valueInIngots;
        public final String materialName;
        public final boolean ignoreDropRate;
        public final boolean enchant;

        public ItemMaterialValue(double valueInIngots, String materialName, boolean ignoreDropRate, boolean enchant) {
            this.valueInIngots = valueInIngots;
            this.materialName = materialName;
            this.ignoreDropRate = ignoreDropRate;
            this.enchant = enchant;
        }
    }
}

