/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.collect.ImmutableList;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

@EligibleIf(configAvailable="*.faster_obsidian")
public class FeatureFasterObsidian
implements Feature {
    private final ImmutableList<Block> BLOCKS = ImmutableList.of((Object)Blocks.f_50080_, (Object)Blocks.f_50723_, (Object)Blocks.f_50265_);

    @Override
    public void apply() {
        this.amendHardness(0.33333334f);
    }

    @Override
    public boolean undo() {
        this.amendHardness(3.0f);
        return true;
    }

    private void amendHardness(float m) {
        for (Block b : this.BLOCKS) {
            for (BlockState bs : b.m_49965_().m_61056_()) {
                try {
                    float base = FabRefl.getHardness((BlockBehaviour.BlockStateBase)bs);
                    float nw = base * m;
                    FabRefl.setHardness((BlockBehaviour.BlockStateBase)bs, nw);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't update hardness", e);
                }
            }
        }
    }

    @Override
    public String getConfigKey() {
        return "*.faster_obsidian";
    }
}

