/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.client.PrideFlagRenderer;
import com.unascribed.fabrication.client.ScrollBar;
import com.unascribed.fabrication.loaders.LoaderYeetRecipes;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class YeetRecipesScreen
extends Screen {
    final ScrollBar yeetRecipesBar;
    final ScrollBar availableRecipesBar;
    private EditBox searchField;
    Pattern filter;
    Screen parent;
    PrideFlagRenderer prideFlag;
    boolean didClick;
    boolean didRClick;
    double lastMouseX;
    double lastMouseY;

    public YeetRecipesScreen(Screen parent, PrideFlagRenderer prideFlag, String title, String configKey) {
        super((Component)Component.m_237113_((String)"Fabrication Yeet Recipes"));
        this.yeetRecipesBar = new ScrollBar((float)this.f_96544_ / 2.0f);
        this.availableRecipesBar = new ScrollBar(this.yeetRecipesBar.displayHeight - 20.0f);
        this.filter = Pattern.compile("");
        this.parent = parent;
        this.prideFlag = prideFlag;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchField = new EditBox(this.f_96547_, 0, 0, this.f_96543_, 20, this.searchField, (Component)Component.m_237113_((String)"Filter"));
        this.searchField.m_94151_(s -> {
            s = s.trim();
            this.filter = Pattern.compile(s, 18);
        });
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        float y;
        this.m_280273_(drawContext);
        drawContext.m_280509_(0, 22, this.f_96543_, this.f_96544_ / 2 + 10, FabConf.isEnabled("general.dark_mode") ? 0x44FFFFFF : 0x55000000);
        this.searchField.m_88315_(drawContext, mouseX, mouseY, delta);
        if (this.f_96541_.f_91073_ == null) {
            drawContext.m_280056_(this.f_96547_, "Load a world to see suggestions", 5, 25, -1, true);
        } else {
            y = 22.0f - this.availableRecipesBar.getScaledScroll(this.f_96541_);
            for (Recipe clr : this.f_96541_.f_91073_.m_7465_().m_44051_()) {
                if (!this.filter.matcher(clr.m_6423_().toString()).find()) continue;
                if (y > 20.0f) {
                    drawContext.m_280056_(this.f_96547_, clr.m_6423_().toString(), 5, (int)y, -1, true);
                }
                if (this.didClick && y > 20.0f && mouseY > 22 && (float)mouseY > y && (float)mouseY < y + 12.0f) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
                    LoaderYeetRecipes.recipesToYeet.add(clr.m_6423_());
                    LoaderYeetRecipes.instance.set(clr.m_6423_().toString(), "true");
                }
                if (!((y += 12.0f) > (float)this.f_96544_ / 2.0f)) continue;
                break;
            }
            this.availableRecipesBar.height = this.f_96541_.f_91073_.m_7465_().m_44051_().stream().filter(r -> this.filter.matcher(r.m_6423_().toString()).find()).count() * 12L + 20L;
        }
        y = 12.0f + (float)this.f_96544_ / 2.0f - this.yeetRecipesBar.getScaledScroll(this.f_96541_);
        Iterator<ResourceLocation> iter = LoaderYeetRecipes.recipesToYeet.iterator();
        while (iter.hasNext()) {
            Recipe clr;
            clr = iter.next();
            if (y > 10.0f + (float)this.f_96544_ / 2.0f) {
                drawContext.m_280056_(this.f_96547_, clr.toString(), 5, (int)y, -1, true);
            }
            if (this.didRClick && mouseY > 10 + this.f_96544_ / 2 && (float)mouseY > y && (float)mouseY < y + 12.0f) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
                iter.remove();
                LoaderYeetRecipes.instance.remove(clr.toString());
            }
            if (!((y += 12.0f) > (float)this.f_96544_)) continue;
            break;
        }
        this.yeetRecipesBar.height = LoaderYeetRecipes.recipesToYeet.size() * 12 + 20;
        if (this.didClick) {
            this.didClick = false;
        }
        if (this.didRClick) {
            this.didRClick = false;
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.yeetRecipesBar.tick();
        this.availableRecipesBar.tick();
    }

    public void m_280273_(GuiGraphics matrices) {
        FabricationConfigScreen.drawBackground(this.f_96544_, this.f_96543_, this.f_96541_, this.prideFlag, 0.0f, matrices, 0, 0, 0.0f, 0, 0);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.didClick = true;
        } else if (button == 1) {
            this.didRClick = true;
        }
        this.searchField.m_6375_(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (mouseY > (double)this.f_96544_ / 2.0) {
            this.yeetRecipesBar.scroll(amount * 20.0);
        } else {
            this.availableRecipesBar.scroll(amount * 20.0);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        this.searchField.m_7933_(keyCode, scanCode, modifiers);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.searchField.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.searchField.m_94757_(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.searchField.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char chr, int modifiers) {
        this.searchField.m_5534_(chr, modifiers);
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.searchField.m_7920_(keyCode, scanCode, modifiers);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void m_6574_(Minecraft client, int width, int height) {
        this.yeetRecipesBar.displayHeight = (float)height / 2.0f;
        this.availableRecipesBar.displayHeight = this.yeetRecipesBar.displayHeight - 20.0f;
        super.m_6574_(client, width, height);
    }
}

