/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.client.PrideFlagRenderer;
import com.unascribed.fabrication.client.ScrollBar;
import com.unascribed.fabrication.features.FeatureTaggablePlayers;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaggablePlayersScreen
extends Screen {
    final ScrollBar scrollBar;
    private EditBox searchField;
    Pattern filter;
    Screen parent;
    PrideFlagRenderer prideFlag;
    boolean didClick;
    double lastMouseX;
    double lastMouseY;

    public TaggablePlayersScreen(Screen parent, PrideFlagRenderer prideFlag, String title, String configKey) {
        super((Component)Component.m_237113_((String)"Fabrication Taggable Players"));
        this.scrollBar = new ScrollBar(this.f_96544_);
        this.filter = Pattern.compile("");
        this.parent = parent;
        this.prideFlag = prideFlag;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchField = new EditBox(this.f_96547_, 0, 0, this.f_96543_, 20, this.searchField, (Component)Component.m_237113_((String)"Filter"));
        this.searchField.m_94151_(s -> {
            s = s.trim();
            this.filter = Pattern.compile(s, 18);
        });
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.m_280273_(drawContext);
        this.searchField.m_88315_(drawContext, mouseX, mouseY, delta);
        float scroll = this.scrollBar.getScaledScroll(this.f_96541_);
        float y = 22.0f - scroll;
        for (Map.Entry entry : FeatureTaggablePlayers.validTags.entrySet()) {
            String key = (String)entry.getKey();
            if (!this.filter.matcher(key).find()) continue;
            if (y > 22.0f) {
                boolean isActive = FeatureTaggablePlayers.activeTags.containsKey(key);
                drawContext.m_280056_(this.f_96547_, key, 5, (int)y, isActive ? (FabConf.isEnabled(key) ? -1 : -56798) : -5592406, true);
                if (isActive) {
                    int val = FeatureTaggablePlayers.activeTags.get(key);
                    int mask = (Integer)entry.getValue();
                    if ((mask & 1) != 0 && this.drawToggleButton(drawContext, this.f_96543_ - 160, (int)y, 45, 10, "Invert", mouseX, mouseY, (val & 1) != 0)) {
                        FeatureTaggablePlayers.add(key, val ^ 1);
                    } else if ((mask & 2) != 0 && this.drawToggleButton(drawContext, this.f_96543_ - 100, (int)y, 90, 10, "Player Exclusive", mouseX, mouseY, (val & 2) == 0)) {
                        FeatureTaggablePlayers.add(key, val ^ 2);
                    } else if (this.didClick && (float)mouseY > y && (float)mouseY < y + 12.0f) {
                        FeatureTaggablePlayers.remove(key);
                    }
                } else if (this.didClick && (float)mouseY > y && (float)mouseY < y + 12.0f) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
                    FeatureTaggablePlayers.add(key, 0);
                }
            }
            if (!((y += 12.0f) > (float)this.f_96544_)) continue;
            break;
        }
        this.scrollBar.height = FeatureTaggablePlayers.validTags.size() * 12 + 8;
        if (this.didClick) {
            this.didClick = false;
        }
    }

    private boolean drawToggleButton(GuiGraphics matrices, int x, int y, int w, int h, String text, float mouseX, float mouseY, boolean toggle) {
        return FabricationConfigScreen.drawToggleButton(matrices, x, y, w, h, text, mouseX, mouseY, toggle, this.didClick, this.f_96541_);
    }

    public void m_86600_() {
        super.m_86600_();
        this.scrollBar.tick();
    }

    public void m_280273_(GuiGraphics matrices) {
        FabricationConfigScreen.drawBackground(this.f_96544_, this.f_96543_, this.f_96541_, this.prideFlag, 0.0f, matrices, 0, 0, 0.0f, 0, 0);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.didClick = true;
        }
        this.searchField.m_6375_(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.scrollBar.scroll(amount * 20.0);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        this.searchField.m_7933_(keyCode, scanCode, modifiers);
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.searchField.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.searchField.m_94757_(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.searchField.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char chr, int modifiers) {
        this.searchField.m_5534_(chr, modifiers);
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.searchField.m_7920_(keyCode, scanCode, modifiers);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void m_6574_(Minecraft client, int width, int height) {
        this.scrollBar.displayHeight = height;
        super.m_6574_(client, width, height);
    }
}

