/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.client.AtlasTracking;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL30C;

public class AtlasViewerScreen
extends Screen {
    private static final ResourceLocation CHECKER = new ResourceLocation("fabrication", "textures/checker.png");
    private final ResourceLocation atlas;
    private float panX = 100.0f;
    private float panY = 100.0f;
    private int level = 0;

    public AtlasViewerScreen(ResourceLocation atlas) {
        super((Component)Component.m_237113_((String)"Atlas viewer"));
        this.atlas = atlas;
    }

    protected void m_7856_() {
        this.f_96541_.f_91079_ = true;
    }

    public void m_7861_() {
        this.f_96541_.f_91079_ = false;
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        int h;
        int w;
        int y;
        int x;
        PoseStack matrices = drawContext.m_280168_();
        matrices.m_85836_();
        RenderSystem.clearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.disableBlend();
        this.f_96541_.m_91097_().m_174784_(CHECKER);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CHECKER);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bb = Tesselator.m_85913_().m_85915_();
        Matrix4f mat = matrices.m_85850_().m_252922_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bb.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bb.m_252986_(mat, (float)this.f_96543_, 0.0f, 0.0f).m_7421_((float)(this.f_96543_ / 8), 0.0f).m_5752_();
        bb.m_252986_(mat, (float)this.f_96543_, (float)this.f_96544_, 0.0f).m_7421_((float)(this.f_96543_ / 8), (float)(this.f_96544_ / 8)).m_5752_();
        bb.m_252986_(mat, 0.0f, (float)this.f_96544_, 0.0f).m_7421_(0.0f, (float)(this.f_96544_ / 8)).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        this.f_96541_.m_91097_().m_174784_(this.atlas);
        matrices.m_252880_(this.panX, this.panY, 0.0f);
        int atlasWidth = GL30C.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int atlasHeight = GL30C.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int atlasMaxLevel = GL30C.glGetTexParameteri((int)3553, (int)33085);
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
        mat = matrices.m_85850_().m_252922_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        bb.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_5752_();
        bb.m_252986_(mat, (float)atlasWidth, 0.0f, 0.0f).m_5752_();
        bb.m_252986_(mat, (float)atlasWidth, (float)atlasHeight, 0.0f).m_5752_();
        bb.m_252986_(mat, 0.0f, (float)atlasHeight, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        GL30C.glTexParameteri((int)3553, (int)33084, (int)this.level);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlas);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mat = matrices.m_85850_().m_252922_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bb.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bb.m_252986_(mat, (float)atlasWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bb.m_252986_(mat, (float)atlasWidth, (float)atlasHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bb.m_252986_(mat, 0.0f, (float)atlasHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        GL30C.glTexParameteri((int)3553, (int)33084, (int)0);
        matrices.m_85849_();
        mouseX = (int)((float)mouseX - this.panX);
        mouseY = (int)((float)mouseY - this.panY);
        TextureAtlas sat = this.getAtlas();
        this.renderTooltip(drawContext, Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)this.atlas.toString()), Component.m_237113_((String)("\u00a77" + atlasWidth + "\u00d7" + atlasHeight + "\u00d7" + (atlasMaxLevel + 1) + " @" + (this.level + 1) + " \u00a7f|\u00a77 " + FabRefl.Client.getSprites(sat).size() + " sprites"))}), -9, 15);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ArrayList sprites = Lists.newArrayList();
        for (TextureAtlasSprite s : FabRefl.Client.getSprites(sat).values()) {
            x = FabRefl.Client.getX(s);
            y = FabRefl.Client.getY(s);
            w = s.m_245424_().m_246492_();
            h = s.m_245424_().m_245330_();
            if (mouseX < x || mouseX >= x + w || mouseY < y || mouseY >= y + h) continue;
            sprites.add(s);
        }
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172808_);
        for (TextureAtlasSprite s : sprites) {
            x = FabRefl.Client.getX(s);
            y = FabRefl.Client.getY(s);
            w = s.m_245424_().m_246492_();
            h = s.m_245424_().m_245330_();
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.2f);
            mat = matrices.m_85850_().m_252922_();
            bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
            bb.m_252986_(mat, this.panX + (float)x, this.panY + (float)y, 0.0f).m_5752_();
            bb.m_252986_(mat, this.panX + (float)x + (float)w, this.panY + (float)y, 0.0f).m_5752_();
            bb.m_252986_(mat, this.panX + (float)x + (float)w, this.panY + (float)y + (float)h, 0.0f).m_5752_();
            bb.m_252986_(mat, this.panX + (float)x, this.panY + (float)y + (float)h, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (sprites.isEmpty()) {
            if (mouseX >= 0 && mouseY >= 0 && mouseX < atlasWidth && mouseY < atlasHeight) {
                this.renderTooltip(drawContext, Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)"<nothing>"), Component.m_237113_((String)("\u00a77" + mouseX + ", " + mouseY)), Component.m_237113_((String)"If there is something here, it's either garbage from your graphics driver or an unregistered sprite")}), (int)((float)mouseX + this.panX), (int)((float)mouseY + this.panY));
            }
        } else if (sprites.size() == 1) {
            TextureAtlasSprite s = (TextureAtlasSprite)sprites.get(0);
            int x2 = FabRefl.Client.getX(s);
            int y2 = FabRefl.Client.getY(s);
            int w2 = s.m_245424_().m_246492_();
            int h2 = s.m_245424_().m_245330_();
            ResourceLocation tex = new ResourceLocation(s.m_245424_().m_246162_().m_135827_(), "textures/" + s.m_245424_().m_246162_().m_135815_() + ".png");
            Object src = "??";
            if (s.getClass() == TextureAtlasSprite.class) {
                try {
                    Optional opt = this.f_96541_.m_91098_().m_213713_(tex);
                    if (opt.isPresent()) {
                        src = ((Resource)opt.get()).m_215506_();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                src = "Custom Sprite subclass " + s.getClass().getName();
            }
            String anim = "";
            this.renderTooltip(drawContext, Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)s.m_245424_().m_246162_().toString()), Component.m_237113_((String)("\u00a77At " + x2 + "," + y2 + " " + w2 + "\u00d7" + h2 + "\u00d7" + anim)), Component.m_237113_((String)("\u00a77From \u00a7f" + (String)src))}), (int)((float)mouseX + this.panX), (int)((float)mouseY + this.panY));
        } else {
            ArrayList li = Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)"\u00a7c\u26a0 MULTIPLE SPRITES \u26a0")});
            for (TextureAtlasSprite s : sprites) {
                int x3 = FabRefl.Client.getX(s);
                int y3 = FabRefl.Client.getY(s);
                int w3 = s.m_245424_().m_246492_();
                int h3 = s.m_245424_().m_245330_();
                li.add(Component.m_237113_((String)s.m_245424_().m_246162_().toString()));
                String anim = "";
                li.add(Component.m_237113_((String)("\u00a77At " + x3 + "," + y3 + " " + w3 + "\u00d7" + h3 + "\u00d7" + anim)));
            }
            this.renderTooltip(drawContext, li, (int)((float)mouseX + this.panX), (int)((float)mouseY + this.panY));
        }
    }

    public void renderTooltip(GuiGraphics matrices, List<Component> lines, int x, int y) {
        ArrayList ordered = Lists.newArrayList();
        for (Component t : lines) {
            ordered.addAll(this.f_96547_.m_92923_((FormattedText)t, 240));
        }
        matrices.m_280245_(this.f_96547_, (List)ordered, x, y);
    }

    private TextureAtlas getAtlas() {
        for (TextureAtlas cand : AtlasTracking.allAtlases) {
            if (!cand.m_118330_().equals((Object)this.atlas)) continue;
            return cand;
        }
        return null;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.panX = (float)((double)this.panX + deltaX);
            this.panY = (float)((double)this.panY + deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int oldBind = GL30C.glGetInteger((int)32873);
        TextureAtlas sat = this.getAtlas();
        if (sat != null) {
            GL30C.glBindTexture((int)3553, (int)sat.m_117963_());
            int maxLevel = GL30C.glGetTexParameteri((int)3553, (int)33085);
            this.level = (int)((double)this.level + amount);
            if (this.level > maxLevel) {
                this.level = maxLevel;
            }
            if (this.level < 0) {
                this.level = 0;
            }
        }
        GL30C.glBindTexture((int)3553, (int)oldBind);
        return true;
    }
}

