/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.MoreFiles;
import com.google.common.io.Resources;
import com.mojang.brigadier.CommandDispatcher;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationModClient;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.SpecialEligibility;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.system.Platform;

public class FabConf {
    private static final ImmutableSet<String> RUNTIME_CONFIGURABLE = ImmutableSet.of((Object)"general.reduced_motion", (Object)"general.data_upload", (Object)"minor_mechanics.feather_falling_five_damages_boots", (Object)"minor_mechanics.observers_see_entities_living_only");
    private static final ImmutableSet<String> validSections;
    private static final ImmutableSet<String> validKeys;
    private static final ImmutableMap<String, String> starMap;
    private static final ImmutableMap<String, ImmutableSet<String>> equivalanceMap;
    private static final ImmutableMap<String, Tuple<ImmutableSet<String>, ImmutableSet<String>>> sectionFeatureKeyToFeatures;
    private static final List<ConfigLoader> loaders;
    private static final Set<SpecialEligibility> metSpecialEligibility;
    private static final Map<String, String> failures;
    private static final Map<String, String> failuresReadOnly;
    private static Map<String, ConfigValues.Feature> worldConfig;
    private static QDIni rawConfig;
    public static Map<String, ConfigValues.Category> categoryConfig;
    private static Map<String, ConfigValues.Feature> config;
    private static ImmutableSet<String> defaults;
    private static Path worldPath;
    public static boolean loadComplete;
    private static final FeaturesIniTransformer featuresIniTransformer;

    public static boolean hasWorldPath() {
        return worldPath != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void determineClientEligibility() {
        FabConf.setMet(SpecialEligibility.NOT_MACOS, Platform.get() != Platform.MACOSX);
    }

    public static void setWorldPath(Path path) {
        FabConf.setWorldPath(path, false);
    }

    public static void setWorldPath(Path path, boolean onLoad) {
        worldPath = path;
        if (path == null) {
            worldConfig.clear();
        } else if (onLoad) {
            Path target = path.resolve(MixinConfigPlugin.MOD_NAME_LOWER);
            Path source = path.resolve(EarlyAgnos.isForge() ? "fabrication" : "forgery");
            if (!Files.exists(target, new LinkOption[0]) && Files.exists(source, new LinkOption[0])) {
                try {
                    Files.move(source, target, new CopyOption[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        FabConf.worldReload();
    }

    public static void setMet(SpecialEligibility se, boolean met) {
        if (met) {
            metSpecialEligibility.add(se);
        } else {
            metSpecialEligibility.remove((Object)se);
        }
    }

    public static boolean isMet(SpecialEligibility se) {
        return metSpecialEligibility.contains((Object)se);
    }

    public static String remap(String configKey) {
        return (String)starMap.getOrDefault((Object)configKey, (Object)configKey);
    }

    public static ImmutableSet<String> getEquivalent(String configKey) {
        return (ImmutableSet)equivalanceMap.getOrDefault((Object)FabConf.remap(configKey), (Object)ImmutableSet.of());
    }

    public static RuntimeException devError(String msg) {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            JFrame dummyFrame = new JFrame();
            dummyFrame.setIconImage(Toolkit.getDefaultToolkit().createImage(FabConf.class.getClassLoader().getResource("assets/fabrication/icon.png")));
            dummyFrame.setSize(1, 1);
            dummyFrame.setLocationRelativeTo(null);
            JOptionPane.showOptionDialog(dummyFrame, msg, "Fabrication Dev Error", 0, 0, null, new String[]{"Exit"}, "Exit");
            System.exit(1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new RuntimeException(msg);
    }

    public static boolean limitRuntimeConfigs() {
        return config.get("general.limit_runtime_configs") == ConfigValues.Feature.TRUE;
    }

    public static boolean isAnyEnabled(String configKey) {
        if (FabConf.isEnabled(configKey)) {
            return true;
        }
        return FabConf.getEquivalent(configKey).stream().anyMatch(FabConf::isEnabled);
    }

    public static boolean isEnabled(String configKey) {
        ConfigValues.Feature worldVal;
        if (FabConf.isFailed(configKey) || FabConf.isBanned(configKey)) {
            return false;
        }
        if (!validKeys.contains((Object)(configKey = FabConf.remap(configKey)))) {
            FabLog.error("Cannot look up value for config key " + configKey + " with no default");
            return false;
        }
        if (FabConf.hasWorldPath() && (worldVal = worldConfig.get(configKey)) != ConfigValues.Feature.UNSET && worldVal != null) {
            return worldVal == ConfigValues.Feature.TRUE;
        }
        if (!config.containsKey(configKey)) {
            return defaults.contains((Object)configKey);
        }
        return config.get(configKey).resolve(defaults.contains((Object)configKey));
    }

    public static boolean isBanned(String configKey) {
        String k = FabConf.remap(configKey);
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT && loadComplete && FabConf.clientCheckBanned(k)) {
            return true;
        }
        ConfigValues.Feature worldVal = worldConfig.get(configKey);
        if (worldVal == ConfigValues.Feature.BANNED) {
            return true;
        }
        return config.get(k) == ConfigValues.Feature.BANNED;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean clientCheckBanned(String configKey) {
        return FabricationModClient.isBannedByServer(configKey);
    }

    public static boolean isFailed(String configKey) {
        return failures.containsKey(FabConf.remap(configKey));
    }

    public static String getFailed(String configKey) {
        return failures.get(FabConf.remap(configKey));
    }

    public static ConfigValues.Feature getValue(String configKey) {
        ConfigValues.Feature worldVal;
        if (FabConf.isBanned(configKey)) {
            return ConfigValues.Feature.BANNED;
        }
        if (FabConf.isFailed(configKey)) {
            return ConfigValues.Feature.FALSE;
        }
        if (FabConf.hasWorldPath() && (worldVal = worldConfig.get(configKey)) != ConfigValues.Feature.UNSET && worldVal != null) {
            return worldVal;
        }
        return config.getOrDefault(FabConf.remap(configKey), ConfigValues.Feature.UNSET);
    }

    public static boolean doesWorldContainValue(String configKey) {
        ConfigValues.Feature val = worldConfig.get(configKey);
        return val != null && val != ConfigValues.Feature.UNSET;
    }

    public static boolean doesWorldContainValue(String configKey, String configVal) {
        if (!worldConfig.containsKey(configKey)) {
            return false;
        }
        return worldConfig.get(configKey).toString().equals(configVal.toUpperCase(Locale.ROOT));
    }

    public static ConfigValues.ResolvedFeature getResolvedValue(String configKey) {
        return FabConf.getResolvedValue(configKey, false);
    }

    public static ConfigValues.ResolvedFeature getResolvedValue(String configKey, boolean includeWorld) {
        if (FabConf.isBanned(configKey)) {
            return ConfigValues.ResolvedFeature.BANNED;
        }
        if (FabConf.isFailed(configKey)) {
            return ConfigValues.ResolvedFeature.FALSE;
        }
        if (includeWorld && FabConf.hasWorldPath()) {
            ConfigValues.Feature cv;
            return worldConfig.getOrDefault(FabConf.remap(configKey), ConfigValues.Feature.UNSET).resolveSemantically((cv = config.get(FabConf.remap(configKey))) == ConfigValues.Feature.TRUE || cv == ConfigValues.Feature.UNSET && defaults.contains((Object)configKey));
        }
        return config.getOrDefault(FabConf.remap(configKey), ConfigValues.Feature.UNSET).resolveSemantically(defaults.contains((Object)configKey));
    }

    public static boolean isRuntimeConfigurable(String s) {
        return RUNTIME_CONFIGURABLE.contains((Object)s);
    }

    public static String getRawValue(String configKey) {
        configKey = FabConf.remap(configKey);
        return rawConfig.get(configKey).orElse("");
    }

    public static boolean isValid(String configKey) {
        return validKeys.contains((Object)FabConf.remap(configKey));
    }

    public static boolean getDefault(String configKey) {
        return defaults.contains((Object)FabConf.remap(configKey));
    }

    public static ImmutableSet<String> getAllKeys() {
        return validKeys;
    }

    public static ImmutableSet<String> getAllSections() {
        return validSections;
    }

    public static Map<String, String> getAllFailures() {
        return failuresReadOnly;
    }

    public static Collection<String> getAllBanned() {
        return Collections2.transform((Collection)Collections2.filter(config.entrySet(), en -> {
            ConfigValues.Feature worldVal = worldConfig.get(en.getKey());
            return en.getValue() == ConfigValues.Feature.BANNED || worldVal == ConfigValues.Feature.BANNED;
        }), Map.Entry::getKey);
    }

    public static void addFailure(String configKey, String reason) {
        failures.put(FabConf.remap(configKey), reason);
    }

    private static void getDefaults(Function<String, ConfigValues.Category> getCategory, Consumer<String> add) {
        for (Map.Entry entry : sectionFeatureKeyToFeatures.entrySet()) {
            ConfigValues.Category cat = getCategory.apply((String)entry.getKey());
            if (cat == null) continue;
            switch (cat) {
                case ASH: {
                    for (String str : (ImmutableSet)((Tuple)entry.getValue()).m_14419_()) {
                        add.accept(str);
                    }
                }
                case DARK: {
                    for (String str : (ImmutableSet)((Tuple)entry.getValue()).m_14418_()) {
                        add.accept(str);
                    }
                    break;
                }
            }
        }
    }

    private static ImmutableSet<String> getDefaults(Function<String, ConfigValues.Category> getCategory) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FabConf.getDefaults(getCategory, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static void set(String configKey, String newValue, Path path, boolean isWorld) {
        boolean isCategory = configKey.startsWith("general.category.");
        if (isCategory) {
            if (!ConfigValues.Category.isCategory(newValue)) {
                throw new IllegalArgumentException("Category key " + configKey + " cannot be set to " + newValue);
            }
        } else {
            switch (newValue) {
                case "banned": 
                case "true": 
                case "false": 
                case "unset": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Standard key " + configKey + " cannot be set to " + newValue);
                }
            }
        }
        if (isWorld) {
            if (!isCategory) {
                worldConfig.put(configKey, ConfigValues.Feature.parse(newValue));
            }
        } else {
            rawConfig.put(configKey, newValue);
            if (isCategory) {
                ConfigValues.Category category = ConfigValues.Category.parse(newValue);
                categoryConfig.put(configKey, category);
                defaults = FabConf.getDefaults(categoryConfig::get);
            } else {
                config.put(configKey, ConfigValues.Feature.parse(newValue));
            }
        }
        FabConf.write(configKey, newValue, path);
    }

    public static void worldSet(String configKey, String newValue) {
        if (worldPath == null) {
            FabLog.error("worldSet was called while path was null");
            return;
        }
        FabConf.set(configKey, newValue, worldPath.resolve(MixinConfigPlugin.MOD_NAME_LOWER).resolve("features.ini"), true);
    }

    public static void set(String configKey, String newValue) {
        FabConf.set(configKey, newValue, EarlyAgnos.getConfigDir().resolve(MixinConfigPlugin.MOD_NAME_LOWER).resolve("features.ini"), false);
    }

    private static void write(final String configKey, final String newValue, Path configFile) {
        Stopwatch watch = Stopwatch.createStarted();
        StringWriter sw = new StringWriter();
        try {
            QDIni.loadAndTransform(configFile, new QDIni.IniTransformer(){
                boolean found = false;
                boolean foundEmptySection = false;

                @Override
                public String transformLine(String path, String line) {
                    if (line != null && line.startsWith("[]")) {
                        this.foundEmptySection = true;
                    }
                    if ((line == null || line.equals("; Notices: (Do not edit anything past this line; it will be overwritten)")) && !this.found) {
                        this.found = true;
                        return (this.foundEmptySection ? "" : "[]\r\n") + "; Added by runtime reconfiguration as a last resort as this key could\r\n; not be found elsewhere in the file.\r\n" + configKey + "=" + newValue + "\r\n" + (String)(line == null ? "" : "\r\n" + line);
                    }
                    return line;
                }

                @Override
                public String transformValueComment(String key, String value, String comment) {
                    return comment;
                }

                @Override
                public String transformValue(String key, String value) {
                    if (configKey.equals(key)) {
                        this.found = true;
                        return newValue;
                    }
                    return value;
                }
            }, (Writer)sw);
            Files.write(configFile, sw.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            FabLog.info("Update of " + String.valueOf(configFile) + " done in " + String.valueOf(watch));
        }
        catch (IOException e) {
            FabLog.warn("Failed to update " + String.valueOf(configFile) + " file", e);
        }
    }

    public static void introduce(ConfigLoader ldr) {
        FabConf.load(ldr);
        loaders.add(ldr);
    }

    public static void reload() {
        FabLog.info("Reloading configs...");
        Path dir = EarlyAgnos.getConfigDir().resolve(MixinConfigPlugin.MOD_NAME_LOWER);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new RuntimeException("Failed to create fabrication config directory", e1);
        }
        Path configFile = dir.resolve("features.ini");
        FabConf.checkForAndSaveDefaultsOrUpgrade(configFile, "default_features_config.ini");
        FabLog.timeAndCountWarnings("Loading of features.ini", () -> {
            StringWriter sw = new StringWriter();
            try {
                rawConfig = QDIni.loadAndTransform(configFile, (QDIni.IniTransformer)featuresIniTransformer.reset(), (Writer)sw);
                defaults = FabConf.getDefaults(s -> {
                    try {
                        return rawConfig.get((String)s).map(ConfigValues.Category::parse).orElse(ConfigValues.Category.GREEN);
                    }
                    catch (IllegalArgumentException badVal) {
                        return ConfigValues.Category.GREEN;
                    }
                });
                config = new HashMap<String, ConfigValues.Feature>();
                for (String k : rawConfig.keySet()) {
                    if (k.startsWith("general.category")) {
                        try {
                            categoryConfig.put(k, rawConfig.get(k).map(ConfigValues.Category::parse).orElse(ConfigValues.Category.GREEN));
                        }
                        catch (IllegalArgumentException badVal) {
                            FabLog.warn("Could not parse " + k + " = " + rawConfig.get(k).orElse("") + " - assuming green");
                            categoryConfig.put(k, ConfigValues.Category.GREEN);
                        }
                        continue;
                    }
                    config.put(k, rawConfig.getEnum(k, ConfigValues.Feature.class).orElseGet(() -> {
                        FabLog.warn("Could not parse " + k + " = " + rawConfig.get(k).orElse("") + " - assuming unset");
                        return ConfigValues.Feature.UNSET;
                    }));
                }
            }
            catch (QDIni.SyntaxErrorException e) {
                FabLog.warn("Failed to load configuration file: " + e.getMessage() + "; will assume defaults");
                config = validKeys.stream().collect(Collectors.toMap(v -> v, v -> ConfigValues.Feature.UNSET));
            }
            catch (IOException e) {
                FabLog.warn("Failed to load configuration file; will assume defaults", e);
                config = validKeys.stream().collect(Collectors.toMap(v -> v, v -> ConfigValues.Feature.UNSET));
            }
            try {
                Files.write(configFile, sw.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                FabLog.warn("Failed to transform configuration file", e);
            }
        });
        FabConf.worldReload();
        for (ConfigLoader ldr : loaders) {
            FabConf.load(ldr);
        }
    }

    public static void worldReload() {
        if (worldPath == null) {
            return;
        }
        Path dir = worldPath.resolve(MixinConfigPlugin.MOD_NAME_LOWER);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e1) {
            throw new RuntimeException("Failed to create fabrication world config directory", e1);
        }
        Path configFile = dir.resolve("features.ini");
        FabConf.checkForAndSaveDefaultsOrUpgrade(configFile, "default_features_config.ini", QDIni.IniTransformer.simpleValueIniTransformer((k, v) -> "unset"));
        FabLog.timeAndCountWarnings("Loading of features.ini", () -> {
            StringWriter sw = new StringWriter();
            try {
                QDIni rawConfig = QDIni.loadAndTransform(configFile, (QDIni.IniTransformer)featuresIniTransformer.reset(), (Writer)sw);
                worldConfig = new HashMap<String, ConfigValues.Feature>();
                for (String k : rawConfig.keySet()) {
                    worldConfig.put(k, rawConfig.getEnum(k, ConfigValues.Feature.class).orElseGet(() -> {
                        FabLog.warn("Could not parse " + k + " = " + rawConfig.get(k).orElse("") + " - assuming unset");
                        return ConfigValues.Feature.UNSET;
                    }));
                }
            }
            catch (QDIni.SyntaxErrorException e) {
                FabLog.warn("Failed to load configuration file: " + e.getMessage() + "; will assume defaults");
                worldConfig = validKeys.stream().collect(Collectors.toMap(v -> v, v -> ConfigValues.Feature.UNSET));
            }
            catch (IOException e) {
                FabLog.warn("Failed to load configuration file; will assume defaults", e);
                worldConfig = validKeys.stream().collect(Collectors.toMap(v -> v, v -> ConfigValues.Feature.UNSET));
            }
            try {
                Files.write(configFile, sw.toString().getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                FabLog.warn("Failed to transform configuration file", e);
            }
        });
    }

    private static void load(ConfigLoader ldr) {
        String name = ldr.getConfigName();
        Path dir = EarlyAgnos.getConfigDir().resolve(MixinConfigPlugin.MOD_NAME_LOWER);
        Path file = dir.resolve(name + ".ini");
        FabConf.checkForAndSaveDefaultsOrUpgrade(file, "default_" + name + "_config.ini");
        FabLog.timeAndCountWarnings("Loading of " + name + ".ini", () -> {
            try {
                ldr.load(dir, QDIni.load(file), false);
            }
            catch (QDIni.SyntaxErrorException e) {
                FabLog.warn("Failed to load " + name + ": " + e.getMessage());
                ldr.load(dir, QDIni.load("<empty>", ""), true);
            }
            catch (IOException e) {
                FabLog.warn("Failed to load " + name + " configuration file", e);
            }
        });
    }

    private static void checkForAndSaveDefaultsOrUpgrade(Path configFile, String defaultName) {
        FabConf.checkForAndSaveDefaultsOrUpgrade(configFile, defaultName, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkForAndSaveDefaultsOrUpgrade(Path configFile, String defaultName, QDIni.IniTransformer transformer) {
        if (Files.exists(configFile, new LinkOption[0])) return;
        Path configFileLegacy = configFile.getParent().getParent().resolve((String)(defaultName.equals("default_features_config.ini") ? "fabrication.ini" : "fabrication_" + configFile.getFileName().toString()));
        boolean migrated = false;
        if (Files.exists(configFileLegacy, new LinkOption[0])) {
            try {
                Files.move(configFileLegacy, configFile, new CopyOption[0]);
                migrated = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to move legacy config file into directory");
            }
        }
        Path configFileLegacyOld = configFileLegacy.resolveSibling(String.valueOf(configFileLegacy.getFileName()) + ".old");
        Path configFileOld = configFile.resolveSibling(String.valueOf(configFile.getFileName()) + ".old");
        if (Files.exists(configFileLegacyOld, new LinkOption[0])) {
            try {
                Files.move(configFileLegacyOld, configFileOld, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to move legacy old config file into directory");
            }
        }
        boolean loadedLegacy = false;
        if (Files.exists(configFileOld, new LinkOption[0])) {
            try {
                QDIni currentValues = QDIni.load(configFileOld);
                transformer = QDIni.IniTransformer.simpleValueIniTransformer((key, value) -> currentValues.get(key).orElse(value));
                loadedLegacy = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to upgrade config", e);
            }
        }
        if (transformer != null) {
            try {
                QDIni.loadAndTransform(defaultName, new InputStreamReader(FabConf.class.getClassLoader().getResourceAsStream(defaultName), Charsets.UTF_8), transformer, (Writer)new OutputStreamWriter(Files.newOutputStream(configFile, new OpenOption[0]), Charsets.UTF_8));
                if (!loadedLegacy) return;
                Files.delete(configFileOld);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to upgrade config", e);
            }
        }
        if (migrated) return;
        try {
            Resources.asByteSource((URL)FabConf.class.getClassLoader().getResource(defaultName)).copyTo(MoreFiles.asByteSink((Path)configFile, (OpenOption[])new OpenOption[0]));
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write default config", e);
        }
    }

    static {
        loaders = Lists.newArrayList();
        metSpecialEligibility = EnumSet.noneOf(SpecialEligibility.class);
        failures = Maps.newHashMap();
        failuresReadOnly = Collections.unmodifiableMap(failures);
        worldConfig = new HashMap<String, ConfigValues.Feature>();
        categoryConfig = new HashMap<String, ConfigValues.Category>();
        config = new HashMap<String, ConfigValues.Feature>();
        defaults = ImmutableSet.of();
        worldPath = null;
        loadComplete = false;
        featuresIniTransformer = new FeaturesIniTransformer();
        if (EarlyAgnos.isForge()) {
            FabConf.setMet(SpecialEligibility.FORGE, true);
        } else {
            FabConf.setMet(SpecialEligibility.NOT_FORGE, true);
        }
        try {
            Class.forName("optifine.Installer", false, FabConf.class.getClassLoader());
        }
        catch (Throwable t) {
            FabConf.setMet(SpecialEligibility.NO_OPTIFINE, true);
        }
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            FabConf.determineClientEligibility();
        }
        if (FabConf.class.getClassLoader().getResource("default_features_config.ini") == null) {
            throw FabConf.devError("You must run build-features.sh before running the game.");
        }
        LinkedHashMap starMapBldr = Maps.newLinkedHashMap();
        LinkedHashMap equivalanceMapBldr = Maps.newLinkedHashMap();
        LinkedHashMap sectionFeatureKeyToFeaturesBldr = Maps.newLinkedHashMap();
        LinkedHashSet keys = Sets.newLinkedHashSet();
        LinkedHashSet sections = Sets.newLinkedHashSet();
        for (Map.Entry en : FeaturesFile.getAll().entrySet()) {
            String extend;
            if (((FeaturesFile.FeatureEntry)en.getValue()).meta) continue;
            if (((FeaturesFile.FeatureEntry)en.getValue()).section) {
                sections.add((String)en.getKey());
                continue;
            }
            String key = (String)en.getKey();
            if (key.startsWith("general.category.")) {
                sectionFeatureKeyToFeaturesBldr.put(key, new Tuple((Object)Sets.newHashSet(), (Object)Sets.newHashSet()));
            }
            if ((extend = ((FeaturesFile.FeatureEntry)en.getValue()).extend) != null) {
                if (!equivalanceMapBldr.containsKey(extend)) {
                    equivalanceMapBldr.put(extend, new HashSet());
                }
                ((Set)equivalanceMapBldr.get(extend)).add(key);
            }
            keys.add(key);
            int dot = key.indexOf(46);
            if (dot == -1) continue;
            starMapBldr.put("*" + key.substring(dot), key);
            int lastDot = key.lastIndexOf(46);
            if (lastDot == dot) continue;
            starMapBldr.put("*" + key.substring(lastDot), key);
        }
        for (String key : keys) {
            Set set;
            Tuple sets;
            int dot = key.indexOf(46);
            if (dot == -1 || (sets = (Tuple)sectionFeatureKeyToFeaturesBldr.get("general.category." + key.substring(0, dot))) == null) continue;
            Set set2 = set = FeaturesFile.get((String)key).extra ? (Set)sets.m_14419_() : (Set)sets.m_14418_();
            if (set == null) continue;
            set.add(key);
        }
        starMap = ImmutableMap.copyOf((Map)starMapBldr);
        equivalanceMap = ImmutableMap.copyOf(equivalanceMapBldr.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, ImmutableSet>(FabConf.remap((String)e.getKey()), ImmutableSet.copyOf((Collection)((Collection)e.getValue())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        validKeys = ImmutableSet.copyOf((Collection)keys);
        validSections = ImmutableSet.copyOf((Collection)sections);
        sectionFeatureKeyToFeatures = ImmutableMap.copyOf(sectionFeatureKeyToFeaturesBldr.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Tuple>((String)e.getKey(), new Tuple((Object)ImmutableSet.copyOf((Collection)((Collection)((Tuple)e.getValue()).m_14418_())), (Object)ImmutableSet.copyOf((Collection)((Collection)((Tuple)e.getValue()).m_14419_()))))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static class FeaturesIniTransformer
    implements QDIni.IniTransformer {
        static final String NOTICES_HEADER = "; Notices: (Do not edit anything past this line; it will be overwritten)";
        Set<String> encounteredKeys = Sets.newHashSet();
        List<String> notices = Lists.newArrayList();
        boolean encounteredNotices = false;

        private FeaturesIniTransformer() {
        }

        public FeaturesIniTransformer reset() {
            this.encounteredKeys = Sets.newHashSet();
            this.notices = Lists.newArrayList();
            this.encounteredNotices = false;
            return this;
        }

        @Override
        public String transformLine(String path, String line) {
            if (!this.encounteredNotices && line == null || line != null && line.trim().equals(NOTICES_HEADER)) {
                this.encounteredNotices = true;
                boolean badKeys = false;
                for (String s : validKeys) {
                    if (this.encounteredKeys.contains(s)) continue;
                    this.notices.add("- " + s + " was not found");
                    badKeys = true;
                }
                for (String s : this.encounteredKeys) {
                    if (validKeys.contains((Object)s)) continue;
                    this.notices.add("- " + s + " is not recognized");
                    badKeys = true;
                }
                if (badKeys) {
                    this.notices.add("Consider updating this config file by renaming it to fabrication.ini.old");
                }
                if (this.notices.isEmpty()) {
                    return "; Notices: (Do not edit anything past this line; it will be overwritten)\r\n; - No notices. You're in the clear!";
                }
                return "; Notices: (Do not edit anything past this line; it will be overwritten)\r\n; " + Joiner.on((String)"\r\n; ").join(this.notices);
            }
            return this.encounteredNotices ? null : line;
        }

        @Override
        public String transformValueComment(String key, String value, String comment) {
            return comment;
        }

        @Override
        public String transformValue(String key, String value) {
            this.encounteredKeys.add(key);
            return value;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Client {
        public static boolean serverHasFabrication() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return false;
            }
            CommandDispatcher disp = player.f_108617_.m_105146_();
            return disp.getRoot().getChild(MixinConfigPlugin.MOD_NAME_LOWER) != null || disp.getRoot().getChild(MixinConfigPlugin.MOD_NAME_LOWER_OTHER) != null;
        }
    }
}

