/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.NoiseWiringHelper;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;

public class TectonicCommand {
    private static final ResourceKey<DensityFunction> EROSION = TectonicCommand.key("noise/continent/erosion");
    private static final ResourceKey<DensityFunction> REGION_SELECTOR = TectonicCommand.key("noise/region_selector");
    private static final ResourceKey<DensityFunction> DEPTH_CUTOFF = TectonicCommand.key("__constants/cave/depth_cutoff");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tectonic").requires(stack -> stack.m_6761_(2))).executes(TectonicCommand::run));
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        BlockPos pos = source.m_81375_().m_20183_();
        if (!ConfigHandler.getState().general.modEnabled) {
            TectonicCommand.failure(source, "Tectonic is not currently enabled.");
            return 0;
        }
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) {
            TectonicCommand.failure(source, "Tectonic generation is not present here.");
            return 0;
        }
        NoiseBasedChunkGenerator generator = (NoiseBasedChunkGenerator)chunkGenerator;
        TectonicCommand.message(source, (Component)Component.m_237113_((String)"Tectonic debug info:"));
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)generator.m_224341_().m_203334_();
        RandomState randomState = RandomState.m_255302_((NoiseGeneratorSettings)settings, (HolderGetter)level.m_9598_().m_255025_(Registries.f_256865_), (long)level.m_7328_());
        NoiseWiringHelper helper = new NoiseWiringHelper(level.m_7328_(), settings.f_209354_(), randomState, ((RandomStateAccessor)randomState).getRandom());
        HolderLookup.RegistryLookup registry = level.m_9598_().m_255025_(Registries.f_257040_);
        TectonicCommand.message(source, TectonicCommand.getRegion(TectonicCommand.get((Holder<DensityFunction>)registry.m_255043_(EROSION), helper, pos), TectonicCommand.get((Holder<DensityFunction>)registry.m_255043_(REGION_SELECTOR), helper, pos)));
        TectonicCommand.message(source, (Component)Component.m_264642_((String)"command.tectonic.depth_cutoff", (String)"Depth cutoff: %s", (Object[])new Object[]{TectonicCommand.get((Holder<DensityFunction>)registry.m_255043_(DEPTH_CUTOFF), helper, pos)}));
        return 1;
    }

    private static void message(CommandSourceStack source, Component message) {
        source.m_243053_(message);
    }

    private static void failure(CommandSourceStack source, String message) {
        source.m_81352_((Component)Component.m_237113_((String)message));
    }

    private static double get(Holder<DensityFunction> holder, NoiseWiringHelper helper, BlockPos pos) {
        double d = ((DensityFunction)holder.m_203334_()).m_207456_((DensityFunction.Visitor)helper).m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    private static Component getRegion(double erosion, double regionSelector) {
        String nameText;
        String iconText;
        if (erosion < 0.0) {
            if (regionSelector < 0.0) {
                iconText = "\u2663";
                nameText = "Club";
            } else {
                iconText = "\u2665";
                nameText = "Heart";
            }
        } else if (regionSelector < 0.0) {
            iconText = "\u2660";
            nameText = "Spade";
        } else {
            iconText = "\u2666";
            nameText = "Diamond";
        }
        MutableComponent icon = Component.m_237113_((String)iconText);
        icon.m_130940_(regionSelector < 0.0 ? ChatFormatting.DARK_GRAY : ChatFormatting.RED);
        MutableComponent name = Component.m_237113_((String)nameText);
        return Component.m_264642_((String)"command.tectonic.region", (String)"Region: %s %s (Erosion %s / Region Selector %s)", (Object[])new Object[]{icon, name, erosion, regionSelector});
    }

    private static double round(double erosion) {
        return (double)Math.round(erosion * 1000.0) / 1000.0;
    }

    private static ResourceKey<DensityFunction> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)Tectonic.id(name));
    }
}

