/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection.selectors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public record MultiResourceSelector(List<ConditionedResourceSelector> selectors) implements ResourceSelector<MultiResourceSelector>
{
    public MultiResourceSelector(ConditionedResourceSelector ... selectors) {
        this(List.of(selectors));
    }

    public MultiResourceSelector(ResourceSelector<?> ... selectors) {
        this(Stream.of(selectors).map(ConditionedResourceSelector::new).toList());
    }

    @Override
    public Either<Set<ResourceLocation>, Predicate<ResourceLocation>> select() {
        List<ConditionedResourceSelector> selectors = this.selectors;
        Either<Set<ResourceLocation>, Predicate<ResourceLocation>> either = selectors.get(0).select();
        Optional locations = either.left();
        Predicate<ResourceLocation> combinedPredicate = locations.isPresent() ? ((Set)locations.get())::contains : (Predicate<ResourceLocation>)either.right().get();
        for (int i = 1; i < selectors.size(); ++i) {
            either = selectors.get(i).select();
            locations = either.left();
            combinedPredicate = combinedPredicate.or(locations.isPresent() ? ((Set)locations.get())::contains : (Predicate<ResourceLocation>)either.right().get());
        }
        return Either.right(combinedPredicate);
    }

    public Serializer getSerializer() {
        return ResourceSelectorSerializers.MULTI;
    }

    public static final class Serializer
    implements ResourceSelector.Serializer<MultiResourceSelector> {
        @Override
        public JsonElement serialize(MultiResourceSelector selector) {
            JsonArray jsonArray = new JsonArray();
            selector.selectors.forEach(conditionedModifierTargetSelector -> jsonArray.add(conditionedModifierTargetSelector.serialize()));
            return jsonArray;
        }

        @Override
        public MultiResourceSelector deserialize(JsonElement element) {
            JsonArray jsonArray = element.getAsJsonArray();
            ArrayList<ConditionedResourceSelector> targetSelectors = new ArrayList<ConditionedResourceSelector>(jsonArray.size());
            jsonArray.forEach(entry -> targetSelectors.add(ConditionedResourceSelector.deserialize(entry.toString(), entry)));
            return new MultiResourceSelector(targetSelectors);
        }
    }
}

