/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits.api;

import com.eccarrascon.structurecredits.StructureCredits;
import com.eccarrascon.structurecredits.StructureCreditsClient;
import java.util.HashMap;
import java.util.Map;

public class StructureCreditsAPI {
    private static final Map<String, String> pendingMappings = new HashMap<String, String>();

    public static void registerCustomStructure(String originalStructure, String customStructure) {
        if (StructureCreditsClient.CONFIG_VALUES == null) {
            pendingMappings.put(originalStructure, customStructure);
        } else {
            StructureCreditsClient.CONFIG_VALUES.getCustomStructureName().put(originalStructure, customStructure);
            StructureCreditsClient.CONFIG.save();
            StructureCredits.LOGGER.info("Registered custom structure name: {} -> {}", (Object)originalStructure, (Object)customStructure);
        }
    }

    public static void registerCustomStructures(Map<String, String> mappings) {
        if (StructureCreditsClient.CONFIG_VALUES == null) {
            pendingMappings.putAll(mappings);
        } else {
            mappings.forEach((originalStructure, customStructure) -> {
                StructureCreditsClient.CONFIG_VALUES.getCustomStructureName().put((String)originalStructure, (String)customStructure);
                StructureCredits.LOGGER.info("Registered custom structure name: {} -> {}", originalStructure, customStructure);
            });
            StructureCreditsClient.CONFIG.save();
        }
    }

    public static void flushPendingMappings() {
        if (StructureCreditsClient.CONFIG_VALUES != null) {
            pendingMappings.forEach((original, custom) -> {
                StructureCreditsClient.CONFIG_VALUES.getCustomStructureName().put((String)original, (String)custom);
                StructureCredits.LOGGER.info("Flushed pending mapping: {} -> {}", original, custom);
            });
            if (!pendingMappings.isEmpty()) {
                StructureCreditsClient.CONFIG.save();
            }
            pendingMappings.clear();
        }
    }
}

