/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import xaero.pac.client.player.config.PlayerConfigClientStorage;
import xaero.pac.common.packet.config.ClientboundPlayerConfigDynamicOptionsPacket;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public final class PlayerConfigHexOptionSpec
extends PlayerConfigOptionSpec<Integer> {
    private PlayerConfigHexOptionSpec(Class<Integer> type, String id, String shortenedId, List<String> path, Integer defaultValue, BiFunction<PlayerConfig<?>, Integer, Integer> defaultReplacer, String comment, String translation, String[] translationArgs, String commentTranslation, String[] commentTranslationArgs, PlayerConfigOptionCategory category, Function<String, Integer> commandInputParser, Function<Integer, Component> commandOutputWriter, BiPredicate<PlayerConfig<?>, Integer> serverSideValidator, BiPredicate<PlayerConfigClientStorage, Integer> clientSideValidator, String tooltipPrefix, Predicate<PlayerConfigType> configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType syncOptionType, boolean dynamic) {
        super(type, id, shortenedId, path, defaultValue, defaultReplacer, comment, translation, translationArgs, commentTranslation, commentTranslationArgs, category, commandInputParser, commandOutputWriter, serverSideValidator, clientSideValidator, tooltipPrefix, configTypeFilter, syncOptionType, dynamic);
    }

    public static final class Builder
    extends PlayerConfigOptionSpec.Builder<Integer, Builder> {
        protected Builder() {
            super(Integer.class);
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setCommandOutputWriter(o -> Component.m_237113_((String)Integer.toUnsignedString(o, 16).toUpperCase()));
            return (Builder)this.self;
        }

        public static <T> Builder begin() {
            return new Builder().setDefault();
        }

        public PlayerConfigHexOptionSpec build(Map<String, PlayerConfigOptionSpec<?>> dest) {
            if (this.tooltipPrefix == null) {
                this.tooltipPrefix = "(hex code)";
            }
            return (PlayerConfigHexOptionSpec)super.build(dest);
        }

        protected PlayerConfigHexOptionSpec buildInternally(List<String> path, String shortenedId, Function<String, Integer> commandInputParser) {
            commandInputParser = s -> {
                try {
                    return Integer.parseUnsignedInt(s, 16);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(nfe);
                }
            };
            return new PlayerConfigHexOptionSpec(this.type, this.id, shortenedId, path, (Integer)this.defaultValue, this.defaultReplacer, this.comment, this.translation, this.translationArgs, this.commentTranslation, this.commentTranslationArgs, this.category, commandInputParser, this.commandOutputWriter, this.serverSideValidator, this.clientSideValidator, this.tooltipPrefix, (Predicate<PlayerConfigType>)this.configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType.HEX, this.dynamic);
        }
    }
}

