/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ice;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.icicle.IcicleProjectile;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class FrostbiteSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"frostbite");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(5).setCooldownSeconds(0.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.percent_damage", (Object[])new Object[]{Utils.stringTruncation(this.getPercentDamage(spellLevel, caster) * 100.0f, 1)}));
    }

    public FrostbiteSpell() {
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 75;
        this.spellPowerPerLevel = 15;
        this.castTime = 40;
        this.baseManaCost = 100;
    }

    @Override
    public CastType getCastType() {
        return CastType.LONG;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        return Utils.preCastTargetHelper(level, entity, playerMagicData, this, 48, 0.15f);
    }

    @Override
    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        TargetEntityCastData targetingData;
        LivingEntity target;
        ICastData iCastData;
        if (playerMagicData != null && (iCastData = playerMagicData.getAdditionalCastData()) instanceof TargetEntityCastData && (target = (targetingData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            float i = playerMagicData.getCastCompletionPercent();
            float f = entity.f_19797_;
            float distance = entity.m_20270_((Entity)target);
            float density = 2.0f;
            Vec3 start = target.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
            Vec3 delta = entity.m_20182_().m_82546_(target.m_20182_()).m_82541_();
            start = start.m_82549_(delta.m_82490_((double)(i * distance)));
            MagicManager.spawnParticles(level, ParticleHelper.SNOWFLAKE, start.f_82479_ + (double)(this.beamNoise((f + i + 50.0f) * 1.25f) * 0.25f), start.f_82480_ + (double)(this.beamNoise((f + i) * 1.5f) * 0.25f), start.f_82481_ + (double)(this.beamNoise((f + i + 84.0f) * 1.25f) * 0.25f), 1, 0.0, 0.0, 0.0, 0.0, false);
        }
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    private float beamNoise(float f) {
        return (Mth.m_14089_((float)((f %= 360.0f) * 0.25f)) * 2.0f + Mth.m_14031_((float)f) + Mth.m_14089_((float)(2.0f * f)) * 0.25f) * 0.4f;
    }

    @Override
    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetingData;
        LivingEntity target;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (target = (targetingData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            float damage = this.getPercentDamage(spellLevel, entity) * (float)target.m_146888_() / 20.0f;
            DamageSources.applyDamage((Entity)target, damage, this.getDamageSource((Entity)entity));
            target.m_146917_(0);
            MagicManager.spawnParticles(level, ParticleHelper.SNOWFLAKE, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() * 0.5f), target.m_20189_(), 35, target.m_20205_() * 0.5f, target.m_20206_() * 0.5f, target.m_20205_() * 0.5f, 0.03, false);
            if (target.m_21224_()) {
                this.spawnIcicleShards(target.m_20191_().m_82399_(), damage, entity);
                target.m_146870_();
            }
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnIcicleShards(Vec3 origin, float damage, LivingEntity owner) {
        int count = 8;
        int offset = 360 / count;
        for (int i = 0; i < count; ++i) {
            Vec3 motion = new Vec3(0.0, 0.0, 0.55);
            motion = motion.m_82496_(0.5235988f);
            motion = motion.m_82524_((float)(offset * i) * ((float)Math.PI / 180));
            IcicleProjectile shard = new IcicleProjectile(owner.f_19853_, owner);
            shard.setDamage(damage / (float)count);
            shard.m_20256_(motion);
            Vec3 spawn = origin.m_82549_(motion.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(0.5));
            Vec2 angle = Utils.rotationFromDirection(motion);
            shard.m_7678_(spawn.f_82479_, spawn.f_82480_ - shard.m_20191_().m_82376_() / 2.0, spawn.f_82481_, angle.f_82471_, angle.f_82470_);
            owner.f_19853_.m_7967_((Entity)shard);
        }
    }

    public float getPercentDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.01f;
    }
}

