/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.server.command.EnumArgument;

public class IronsDebugCommand {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ironsDebug").requires(p_138819_ -> p_138819_.m_6761_(2))).then(Commands.m_82129_((String)"dataType", (ArgumentType)EnumArgument.enumArgument(IronsDebugCommandTypes.class)).executes(commandContext -> IronsDebugCommand.getDataForType((CommandSourceStack)commandContext.getSource(), (IronsDebugCommandTypes)((Object)((Object)commandContext.getArgument("dataType", IronsDebugCommandTypes.class))))))).then(Commands.m_82127_((String)"spellCount").executes(commandContext -> {
            int i = SpellRegistry.getEnabledSpells().size();
            ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237113_((String)String.valueOf(i)), true);
            return i;
        })));
    }

    public static int getDataForType(CommandSourceStack source, IronsDebugCommandTypes ironsDebugCommandTypes) {
        switch (ironsDebugCommandTypes) {
            case RECASTING: {
                IronsDebugCommand.getReacstingData(source);
            }
        }
        return 1;
    }

    public static void getReacstingData(CommandSourceStack source) {
        ServerPlayer serverPlayer = source.m_230896_();
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        IronsDebugCommand.writeResults(source, magicData.getPlayerRecasts().toString());
    }

    private static void writeResults(CommandSourceStack source, String results) {
        try {
            File file = new File("irons_debug.txt");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(results);
            writer.close();
            MutableComponent component = Component.m_237113_((String)file.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
            source.m_288197_(() -> IronsDebugCommand.lambda$writeResults$5((Component)component), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ Component lambda$writeResults$5(Component component) {
        return Component.m_237110_((String)"commands.irons_spellbooks.irons_debug_command.success", (Object[])new Object[]{component});
    }

    public static enum IronsDebugCommandTypes {
        RECASTING;

    }
}

