/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import com.hollingsworth.arsnouveau.common.util.EasingManager;
import com.hollingsworth.arsnouveau.common.util.EasingType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class EntityLerpedProjectile
extends ColoredProjectile {
    public static final EntityDataAccessor<BlockPos> to = SynchedEntityData.m_135353_(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<BlockPos> from = SynchedEntityData.m_135353_(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.m_135353_(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> DIDOFFSET = SynchedEntityData.m_135353_(EntityLerpedProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int age;
    int maxAge;
    boolean wentUp;

    public EntityLerpedProjectile(Level worldIn, BlockPos from, BlockPos to) {
        this(worldIn, new Vec3i(from.m_123341_(), from.m_123342_(), from.m_123343_()), new Vec3i(to.m_123341_(), to.m_123342_(), to.m_123343_()), 255, 25, 180);
    }

    public EntityLerpedProjectile(Level worldIn, BlockPos from, BlockPos to, int r, int g, int b) {
        this(worldIn, new Vec3i(from.m_123341_(), from.m_123342_(), from.m_123343_()), new Vec3i(to.m_123341_(), to.m_123342_(), to.m_123343_()), r, g, b);
    }

    public EntityLerpedProjectile(EntityType<EntityLerpedProjectile> entityAOEProjectileEntityType, Level world) {
        super(entityAOEProjectileEntityType, world);
    }

    public EntityLerpedProjectile(Level worldIn, Vec3i from, Vec3i to, int r, int g, int b) {
        super((EntityType)ModEntities.LERP_PROJECTILE.get(), worldIn);
        this.f_19804_.m_135381_(EntityFollowProjectile.to, (Object)new BlockPos(to));
        this.f_19804_.m_135381_(EntityFollowProjectile.from, (Object)new BlockPos(from));
        this.maxAge = from.m_123333_(to) * 5;
        this.m_6034_((double)from.m_123341_() + 0.5, from.m_123342_(), (double)from.m_123343_() + 0.5);
        this.f_19804_.m_135381_(RED, (Object)r);
        this.f_19804_.m_135381_(GREEN, (Object)g);
        this.f_19804_.m_135381_(BLUE, (Object)b);
    }

    public static float lerp(double percentCompleted, double startValue, double endValue, EasingType type) {
        if (percentCompleted >= 1.0) {
            return (float)endValue;
        }
        percentCompleted = EasingManager.ease((double)percentCompleted, (EasingType)type, null);
        return (float)EntityLerpedProjectile.lerpInternal(percentCompleted, startValue, endValue);
    }

    public static double lerpInternal(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public double normalize(double value, double min, double max) {
        return 1.0 - (value - min) / (max - min);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        if (this.age > 400) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Vec3 vec3d2 = this.m_20184_();
        BlockPos start = (BlockPos)this.f_19804_.m_135370_(from);
        BlockPos end = (BlockPos)this.f_19804_.m_135370_(to);
        if (BlockUtil.distanceFrom((BlockPos)this.m_20183_(), (BlockPos)end) < 1.0 || this.age > 1000 || BlockUtil.distanceFrom((BlockPos)this.m_20183_(), (BlockPos)end) > 16.0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        double posX = this.m_20185_();
        double posZ = this.m_20189_();
        double time = 1.0 - this.normalize(this.age, 0.0, 80.0);
        EasingType type = EasingType.EaseOutExpo;
        double startY = start.m_123342_();
        double endY = (double)end.m_123342_() + this.getDistanceAdjustment(start, end);
        double lerpX = EntityLerpedProjectile.lerp(time, (double)start.m_123341_() + 0.5, (double)end.m_123341_() + 0.5, type);
        double lerpY = EntityLerpedProjectile.lerp(time, EntityLerpedProjectile.lerp(time, startY, endY, type), EntityLerpedProjectile.lerp(time, endY, startY, type), type);
        double lerpZ = EntityLerpedProjectile.lerp(time, (double)start.m_123343_() + 0.5, (double)end.m_123343_() + 0.5, type);
        BlockPos adjustedPos = new BlockPos(Mth.m_14107_((double)posX), end.m_123342_(), Mth.m_14107_((double)posZ));
        if (BlockUtil.distanceFrom((BlockPos)adjustedPos, (BlockPos)end) <= 0.5) {
            double posY = this.m_20186_() - 0.05;
            this.m_6034_(lerpX, posY, lerpZ);
        } else {
            this.m_6034_(lerpX, lerpY, lerpZ);
        }
        if (this.m_9236_().f_46443_ && this.age > 1) {
            double deltaX = this.m_20185_() - this.f_19790_;
            double deltaY = this.m_20186_() - this.f_19791_;
            double deltaZ = this.m_20189_() - this.f_19792_;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
            int counter = 0;
            for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                if ((counter += this.m_9236_().f_46441_.m_188503_(3)) % (((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()).m_35965_() == 0 ? 1 : 2 * ((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()).m_35965_()) != 0) continue;
                this.m_9236_().m_7106_(GlowParticleData.createData((ParticleColor)new ParticleColor(((Integer)this.f_19804_.m_135370_(RED)).intValue(), ((Integer)this.f_19804_.m_135370_(GREEN)).intValue(), ((Integer)this.f_19804_.m_135370_(BLUE)).intValue())), (double)((float)(this.f_19854_ + deltaX * coeff)), (double)((float)(this.f_19855_ + deltaY * coeff)), (double)((float)(this.f_19856_ + deltaZ * coeff)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)));
            }
        }
    }

    public void setDistanceAdjust(float offset) {
        this.f_19804_.m_135381_(OFFSET, (Object)Float.valueOf(offset));
        this.f_19804_.m_135381_(DIDOFFSET, (Object)true);
    }

    private double getDistanceAdjustment(BlockPos start, BlockPos end) {
        if (((Boolean)this.f_19804_.m_135370_(DIDOFFSET)).booleanValue()) {
            return ((Float)this.f_19804_.m_135370_(OFFSET)).floatValue();
        }
        double distance = BlockUtil.distanceFrom((BlockPos)start, (BlockPos)end);
        if (distance <= 1.5) {
            return 2.5;
        }
        return 3.0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(to, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(from, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DIDOFFSET, (Object)false);
    }

    @NotNull
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.LERP_PROJECTILE.get();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

