/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.immersive_portals;

import alexthw.ars_scalaes.immersive_portals.ArsPortalCommand;
import alexthw.ars_scalaes.immersive_portals.ImmersiveWarpScroll;
import alexthw.ars_scalaes.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.imm_ptl.core.portal.Portal;

public class IPCompat {
    public static RegistryObject<Item> IMMERSIVE_WARP_SCROLL;
    public static RegistryObject<Item> IMMERSIVE_STABILIZED_WARP_SCROLL;

    public static void init() {
        MinecraftForge.EVENT_BUS.register(IPCompat.class);
        IMMERSIVE_WARP_SCROLL = ModRegistry.ITEMS.register("immersive_warp_scroll", () -> new ImmersiveWarpScroll(false));
        IMMERSIVE_STABILIZED_WARP_SCROLL = ModRegistry.ITEMS.register("immersive_stabilized_warp_scroll", () -> new ImmersiveWarpScroll(true));
    }

    public static void createPortal(Entity portal) {
        if (portal != null) {
            portal.m_9236_().m_6249_(portal, portal.m_20191_().m_82400_(4.0), entity -> {
                ItemEntity ie;
                return entity instanceof ItemEntity && (ie = (ItemEntity)entity).m_32055_().m_41720_() instanceof ImmersiveWarpScroll;
            }).stream().findFirst().ifPresent(entity -> {
                Item patt1991$temp;
                ItemStack scrollStack = ((ItemEntity)entity).m_32055_();
                WarpScroll.WarpScrollData data = WarpScroll.WarpScrollData.get((ItemStack)scrollStack);
                if (data.getPos() == null || !((patt1991$temp = scrollStack.m_41720_()) instanceof ImmersiveWarpScroll)) {
                    return;
                }
                ImmersiveWarpScroll scrollItem = (ImmersiveWarpScroll)patt1991$temp;
                if (portal instanceof Portal) {
                    Portal immersivePortal = (Portal)portal;
                    double portalHeight = immersivePortal.m_20191_().f_82292_ - immersivePortal.m_20191_().f_82289_;
                    double portalX = immersivePortal.m_20191_().f_82291_ - immersivePortal.m_20191_().f_82288_;
                    double portalZ = immersivePortal.m_20191_().f_82293_ - immersivePortal.m_20191_().f_82290_;
                    float destX = data.getPos().m_123341_();
                    float destY = data.getPos().m_123342_();
                    float destZ = data.getPos().m_123343_();
                    float rotation = Math.round(data.getRotation().f_82471_ / 90.0f);
                    if (portalX < portalZ) {
                        rotation += 1.0f;
                    }
                    destY = portalHeight >= 1.0 ? (destY += (float)(portalHeight / 2.0)) : (destY += 0.5f);
                    if (portalX < 1.0 || portalX % 2.0 == 1.0) {
                        destX += 0.5f;
                    }
                    if (portalZ < 1.0 || portalZ % 2.0 == 1.0) {
                        destZ += 0.5f;
                    }
                    if (Math.abs(rotation % 2.0f) == 1.0f && (portalX % 2.0 == 0.0 || portalZ % 2.0 == 0.0)) {
                        boolean trigo;
                        boolean bl = trigo = (rotation - 2.0f) % 4.0f + 2.0f == 1.0f;
                        if (trigo && portalZ >= 1.0) {
                            destX += 0.5f;
                            destZ += 0.5f;
                        } else if (trigo && portalX >= 1.0) {
                            destX += 0.5f;
                            destZ -= 0.5f;
                        } else if (!trigo && portalZ >= 1.0) {
                            destX -= 0.5f;
                            destZ += 0.5f;
                        } else if (!trigo && portalX >= 1.0) {
                            destX += 0.5f;
                            destZ += 0.5f;
                        }
                    }
                    if (scrollItem.allowCrossDim || data.canTeleportWithDim(portal.m_9236_())) {
                        immersivePortal.setDestinationDimension(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(data.getDimension())));
                    }
                    immersivePortal.setDestination(new Vec3((double)destX, (double)destY, (double)destZ));
                    PortalCommand.reloadPortal((Portal)immersivePortal);
                }
            });
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ArsPortalCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

