/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_scalaes.glyph;

import alexthw.ars_scalaes.glyph.PehkuiEffect;
import alexthw.ars_scalaes.pehkui.PkCompatHandler;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;

public class EffectResize
extends PehkuiEffect {
    public static final EffectResize INSTANCE = new EffectResize();

    public EffectResize() {
        super("resize", "Resize");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
            ScaleType type = PkCompatHandler.magicScale;
            ScaleData data = type.getScaleData((Entity)living);
            if (spellStats.getAmpMultiplier() == 0.0 && living.m_21124_((MobEffect)PkCompatHandler.RESIZE.get()) != null) {
                living.m_21195_((MobEffect)PkCompatHandler.RESIZE.get());
            } else {
                data.setTargetScale((float)Math.max((Double)this.minScaling.get(), Math.min((Double)this.maxScaling.get(), (double)data.getBaseScale() + spellStats.getAmpMultiplier() / (spellStats.getAmpMultiplier() < 0.0 ? 2.0 * (Double)this.scalingFactor.get() : (Double)this.scalingFactor.get()))));
            }
        }
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        HashSet<AbstractAugment> augments = new HashSet<AbstractAugment>(super.getCompatibleAugments());
        augments.add((AbstractAugment)AugmentDampen.INSTANCE);
        return augments;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.minScaling = builder.comment("Define the minimum size that can be reached.").defineInRange("min_scaling", 0.5, 0.01, 1.0);
        this.maxScaling = builder.comment("Define the maximum size that can be reached.").defineInRange("max_scaling", 7.0, 1.1, 30.0);
        this.scalingFactor = builder.comment("Define the factor of the amplification -> size conversion. The value is doubled for shrinking.").defineInRange("scaling_factor", 5.0, 1.0, 10.0);
    }
}

