/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.network.BarometerPacket;
import net.orcinus.galosphere.network.PlayCooldownSoundPacket;
import net.orcinus.galosphere.network.ResetPerspectivePacket;
import net.orcinus.galosphere.network.SendParticlesPacket;
import net.orcinus.galosphere.network.SendPerspectivePacket;

public class GNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Galosphere.id("network")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();
    protected static int packetID = 0;

    public static void init() {
        INSTANCE.registerMessage(GNetworkHandler.getPacketID(), SendParticlesPacket.class, SendParticlesPacket::write, SendParticlesPacket::read, SendParticlesPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        INSTANCE.registerMessage(GNetworkHandler.getPacketID(), SendPerspectivePacket.class, SendPerspectivePacket::write, SendPerspectivePacket::read, SendPerspectivePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        INSTANCE.registerMessage(GNetworkHandler.getPacketID(), BarometerPacket.class, BarometerPacket::write, BarometerPacket::read, BarometerPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        INSTANCE.registerMessage(GNetworkHandler.getPacketID(), ResetPerspectivePacket.class, ResetPerspectivePacket::write, ResetPerspectivePacket::read, ResetPerspectivePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        INSTANCE.registerMessage(GNetworkHandler.getPacketID(), PlayCooldownSoundPacket.class, PlayCooldownSoundPacket::write, PlayCooldownSoundPacket::read, PlayCooldownSoundPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendToAllInRangeClients(BlockPos pos, ServerLevel level, double distance, SendParticlesPacket message) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_6846_().m_11241_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), distance, level.m_46472_(), INSTANCE.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    public static int getPacketID() {
        return packetID++;
    }
}

