/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.ai.tasks.ConditionalWalkIfTargetOutOfReach;
import net.orcinus.galosphere.entities.ai.tasks.Shake;
import net.orcinus.galosphere.entities.ai.tasks.Smash;
import net.orcinus.galosphere.entities.ai.tasks.Summon;
import net.orcinus.galosphere.entities.ai.tasks.Undermine;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class BerserkerAi {
    public static Brain<?> makeBrain(Berserker berserker, Brain<Berserker> brain) {
        BerserkerAi.initCoreActivity(brain);
        BerserkerAi.initIdleActivity(brain);
        BerserkerAi.initShakeActivity(brain);
        BerserkerAi.initFightActivity(berserker, brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Berserker> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks((MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get())));
    }

    private static void initIdleActivity(Brain<Berserker> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(BerserkerAi::findNearestValidAttackTarget), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), BerserkerAi.createIdleMovementBehaviors()));
    }

    private static void initShakeActivity(Brain<Berserker> brain) {
        brain.m_21895_(Activity.f_219852_, 5, ImmutableList.of((Object)((Object)new Shake())), (MemoryModuleType)GMemoryModuleTypes.IS_SHAKING.get());
    }

    private static void initFightActivity(Berserker berserker, Brain<Berserker> brain) {
        Predicate<LivingEntity> predicate = livingEntity -> {
            Berserker blighted;
            return livingEntity instanceof Berserker && (!(blighted = (Berserker)((Object)livingEntity)).m_217003_(Pose.ROARING) || blighted.getPhase() != Berserker.Phase.UNDERMINE);
        };
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)BehaviorBuilder.m_257845_(Berserker::shouldUseMeleeAttack, (OneShot)MeleeAttack.m_257733_((int)30)), (Object)((Object)new Smash()), (Object)BehaviorBuilder.m_257845_(predicate, ConditionalWalkIfTargetOutOfReach.create(1.2f)), (Object)((Object)new Undermine()), (Object)((Object)new Summon()), (Object)StopAttackingIfTargetInvalid.m_257811_(livingEntity -> !berserker.canTargetEntity((Entity)livingEntity), (mob, livingEntity) -> {}, (boolean)false)), MemoryModuleType.f_26372_);
    }

    private static RunOne<Berserker> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.3f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.2f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Berserker blighted) {
        return blighted.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }

    public static void updateActivity(Berserker blighted) {
        blighted.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219852_, (Object)Activity.f_37988_, (Object)Activity.f_37979_));
    }
}

