/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GParticleTypes;
import org.jetbrains.annotations.Nullable;

public class PinkSaltStrawBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty FALLABLE = BooleanProperty.m_61465_((String)"fallable");
    public static final EnumProperty<StrawShape> STRAW_SHAPE = EnumProperty.m_61587_((String)"straw_shape", StrawShape.class);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape TOP_UP_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final VoxelShape TOP_DOWN_SHAPE = Block.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BOTTOM_UP_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape BOTTOM_DOWN_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final Map<Predicate<BlockState>, SaltReaction> REACTIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(blockState -> blockState.m_60713_(Blocks.f_50715_) && (Integer)blockState.m_61143_((Property)ComposterBlock.f_51913_) > 0, new SaltReaction(blockState -> ((Block)GBlocks.SALINE_COMPOSTER.get()).m_152465_(blockState), 0.5f));
        map.put(blockState -> ((BiMap)WeatheringCopper.f_154886_.get()).containsKey((Object)blockState.m_60734_()), new SaltReaction(blockState -> ((Block)WeatheringCopper.m_154904_((Block)blockState.m_60734_()).orElseThrow()).m_152465_(blockState), 0.0015f));
    });

    public PinkSaltStrawBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FALLABLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(STRAW_SHAPE, (Comparable)((Object)StrawShape.TOP)));
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockPos tip;
        this.maybeTransferFluid(blockState, serverLevel, blockPos, randomSource.m_188501_());
        if (serverLevel.m_8055_(blockPos.m_6625_(2)).m_60713_(Blocks.f_49991_) && ((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue() && blockState.m_61143_((Property)TIP_DIRECTION) == Direction.UP && (tip = this.findTip(blockState, (LevelAccessor)serverLevel, blockPos, 7)) != null && serverLevel.m_6425_(tip.m_7494_()).m_205070_(FluidTags.f_13131_)) {
            serverLevel.m_46597_(tip.m_7494_(), (BlockState)((Block)GBlocks.PINK_SALT_STRAW.get()).m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }
    }

    private boolean isStalactiteStartPos(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return PinkSaltStrawBlock.isStalactite(blockState) && !levelReader.m_8055_(blockPos.m_7494_()).m_60713_((Block)GBlocks.PINK_SALT_STRAW.get());
    }

    public void maybeTransferFluid(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, float f) {
        BlockPos blockPos2 = this.findTip(blockState, (LevelAccessor)serverLevel, blockPos, 11);
        if (blockPos2 == null) {
            return;
        }
        if (!this.isStalactiteStartPos(blockState, (LevelReader)serverLevel, blockPos)) {
            return;
        }
        for (Predicate<BlockState> predicate : REACTIONS.keySet()) {
            BlockPos target = this.findTarget((Level)serverLevel, blockPos2, predicate);
            if (target == null) continue;
            SaltReaction saltReaction = REACTIONS.get(predicate);
            BlockState result = saltReaction.function.apply(serverLevel.m_8055_(target));
            if (f > saltReaction.chance()) {
                return;
            }
            serverLevel.m_46796_(3005, target, 0);
            serverLevel.m_46597_(target, result);
        }
    }

    @Nullable
    private BlockPos findTip(BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos2, int i) {
        if (PinkSaltStrawBlock.isTip(blockState2)) {
            return blockPos2;
        }
        Direction direction = (Direction)blockState2.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.m_60713_((Block)GBlocks.PINK_SALT_STRAW.get()) && blockState.m_61143_((Property)TIP_DIRECTION) == direction;
        return this.findBlockVertical(levelAccessor, blockPos2, direction.m_122421_(), biPredicate, PinkSaltStrawBlock::isTip, i).orElse(null);
    }

    private static boolean isStalactite(BlockState state) {
        return state.m_60713_((Block)GBlocks.PINK_SALT_STRAW.get()) && state.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN;
    }

    @Nullable
    private BlockPos findTarget(Level level, BlockPos blockPos2, Predicate<BlockState> blockStatePredicate) {
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> this.canDripThrough((BlockGetter)level, (BlockPos)blockPos, (BlockState)blockState);
        return this.findBlockVertical((LevelAccessor)level, blockPos2, Direction.DOWN.m_122421_(), biPredicate, blockStatePredicate, 11).orElse(null);
    }

    private boolean canDripThrough(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        if (blockState.m_60795_()) {
            return true;
        }
        if (blockState.m_60804_(blockGetter, blockPos)) {
            return false;
        }
        if (!blockState.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelShape = blockState.m_60812_(blockGetter, blockPos);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82689_);
    }

    private Optional<BlockPos> findBlockVertical(LevelAccessor levelAccessor, BlockPos blockPos, Direction.AxisDirection axisDirection, BiPredicate<BlockPos, BlockState> biPredicate, Predicate<BlockState> predicate, int i) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
        for (int j = 1; j < i; ++j) {
            mutableBlockPos.m_122173_(direction);
            BlockState blockState = levelAccessor.m_8055_((BlockPos)mutableBlockPos);
            if (predicate.test(blockState)) {
                return Optional.of(mutableBlockPos.m_7949_());
            }
            if (!levelAccessor.m_151562_(mutableBlockPos.m_123342_()) && biPredicate.test((BlockPos)mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        int bound;
        int n = bound = (Boolean)blockState.m_61143_((Property)FALLABLE) != false ? 3 : 6;
        if (randomSource.m_188503_(bound) == 0 && blockState.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN) {
            double d = (double)blockPos.m_123341_() + randomSource.m_188500_();
            double e = (double)blockPos.m_123342_() - 0.05;
            double f = (double)blockPos.m_123343_() + randomSource.m_188500_();
            level.m_7106_((ParticleOptions)GParticleTypes.PINK_SALT_FALLING_DUST.get(), d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, STRAW_SHAPE, TIP_DIRECTION, FALLABLE});
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos pos = blockHitResult.m_82425_();
        double length = projectile.m_20184_().m_82553_();
        if (length <= (double)0.4f) {
            return;
        }
        int steps = Mth.m_216271_((RandomSource)level.m_213780_(), (int)20, (int)30) * Mth.m_14165_((double)length);
        for (int i = 0; i < steps; ++i) {
            boolean flag;
            int radius = 3;
            if (level.m_213780_().m_188503_(5) == 0) {
                radius *= 2;
            }
            mutableBlockPos.m_122178_(pos.m_123341_() + Mth.m_216271_((RandomSource)level.m_213780_(), (int)(-radius), (int)radius), pos.m_123342_() + Mth.m_216271_((RandomSource)level.m_213780_(), (int)-2, (int)2), pos.m_123343_() + Mth.m_216271_((RandomSource)level.m_213780_(), (int)(-radius), (int)radius));
            BlockState chosenStates = level.m_8055_((BlockPos)mutableBlockPos);
            boolean bl = flag = chosenStates.m_60713_((Block)this) && chosenStates.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN && chosenStates.m_61143_(STRAW_SHAPE) == StrawShape.BOTTOM;
            if (!flag) continue;
            level.m_46597_((BlockPos)mutableBlockPos, (BlockState)chosenStates.m_60734_().m_152465_(chosenStates).m_61124_((Property)FALLABLE, (Comparable)Boolean.valueOf(true)));
            double distance = Math.sqrt(projectile.m_20275_((double)mutableBlockPos.m_123341_(), (double)mutableBlockPos.m_123342_(), (double)mutableBlockPos.m_123343_()));
            int ticks = Math.max(1, (int)distance);
            level.m_186460_((BlockPos)mutableBlockPos, (Block)this, ticks);
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return blockState;
        }
        Direction direction2 = (Direction)blockState.m_61143_((Property)TIP_DIRECTION);
        if (direction2 == Direction.DOWN && levelAccessor.m_183326_().m_183582_(blockPos, (Object)this)) {
            return blockState;
        }
        if (direction == direction2.m_122424_() && !this.m_7898_(blockState, (LevelReader)levelAccessor, blockPos)) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        }
        StrawShape pinkSaltStrawShape = PinkSaltStrawBlock.calculateStrawShape((LevelReader)levelAccessor, blockPos, direction2);
        return (BlockState)blockState.m_61124_(STRAW_SHAPE, (Comparable)((Object)pinkSaltStrawShape));
    }

    private static StrawShape calculateStrawShape(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        Direction oppositeDirection = direction.m_122424_();
        BlockState blockState = levelReader.m_8055_(blockPos.m_121945_(direction));
        BlockState oppositeState = levelReader.m_8055_(blockPos.m_121945_(oppositeDirection));
        if (!blockState.m_60713_((Block)GBlocks.PINK_SALT_STRAW.get())) {
            return StrawShape.TOP;
        }
        if (!oppositeState.m_60713_((Block)GBlocks.PINK_SALT_STRAW.get())) {
            return StrawShape.BOTTOM;
        }
        return StrawShape.MIDDLE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction direction = blockPlaceContext.m_151260_().m_122424_();
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level levelAccessor = blockPlaceContext.m_43725_();
        Direction direction2 = PinkSaltStrawBlock.calculateTipDirection((LevelReader)levelAccessor, blockPos, direction);
        if (direction2 == null) {
            return null;
        }
        StrawShape pinkSaltStrawShape = PinkSaltStrawBlock.calculateStrawShape((LevelReader)levelAccessor, blockPos, direction2);
        if (pinkSaltStrawShape == null) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction2)).m_61124_(STRAW_SHAPE, (Comparable)((Object)pinkSaltStrawShape))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        Direction direction2;
        if (PinkSaltStrawBlock.isValidPinkSaltStraw(levelReader, blockPos, direction)) {
            direction2 = direction;
        } else if (PinkSaltStrawBlock.isValidPinkSaltStraw(levelReader, blockPos, direction.m_122424_())) {
            direction2 = direction.m_122424_();
        } else {
            return null;
        }
        return direction2;
    }

    private static boolean isValidPinkSaltStraw(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.m_121945_(direction.m_122424_());
        BlockState blockState = levelReader.m_8055_(blockPos2);
        return blockState.m_60783_((BlockGetter)levelReader, blockPos2, direction) || PinkSaltStrawBlock.isPinkSaltStrawWithDirection(blockState, direction);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return PinkSaltStrawBlock.isValidPinkSaltStrawPlacement(levelReader, blockPos, (Direction)blockState.m_61143_((Property)TIP_DIRECTION));
    }

    private static boolean isValidPinkSaltStrawPlacement(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.m_121945_(direction.m_122424_());
        BlockState blockState = levelReader.m_8055_(blockPos2);
        return blockState.m_60783_((BlockGetter)levelReader, blockPos2, direction) || PinkSaltStrawBlock.isPinkSaltStrawWithDirection(blockState, direction);
    }

    private static boolean isPinkSaltStrawWithDirection(BlockState blockState, Direction direction) {
        return blockState.m_60713_((Block)GBlocks.PINK_SALT_STRAW.get()) && blockState.m_61143_((Property)TIP_DIRECTION) == direction;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        boolean up;
        Vec3 vec3 = blockState.m_60824_(blockGetter, blockPos);
        StrawShape value = (StrawShape)((Object)blockState.m_61143_(STRAW_SHAPE));
        boolean bl = up = blockState.m_61143_((Property)TIP_DIRECTION) == Direction.UP;
        VoxelShape voxelShape = value == StrawShape.TOP ? (up ? TOP_UP_SHAPE : TOP_DOWN_SHAPE) : (value == StrawShape.BOTTOM ? (up ? BOTTOM_UP_SHAPE : BOTTOM_DOWN_SHAPE) : MIDDLE_SHAPE);
        return voxelShape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)FALLABLE)).booleanValue()) {
            BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
            BlockState blockState2 = blockState;
            while (blockState2.m_60713_((Block)GBlocks.PINK_SALT_STRAW.get()) && blockState2.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN) {
                FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)mutableBlockPos, (BlockState)blockState2);
                if (PinkSaltStrawBlock.isTip(blockState2)) {
                    int i = Math.max(1 + blockPos.m_123342_() - mutableBlockPos.m_123342_(), 6);
                    float f = i;
                    fallingBlockEntity.m_149656_(f, 40);
                    break;
                }
                mutableBlockPos.m_122173_(Direction.DOWN);
                blockState2 = serverLevel.m_8055_((BlockPos)mutableBlockPos);
            }
        }
        if (!blockState.m_60710_((LevelReader)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    private static boolean isTip(BlockState blockState) {
        if (!blockState.m_60713_((Block)GBlocks.PINK_SALT_STRAW.get())) {
            return false;
        }
        return blockState.m_61143_(STRAW_SHAPE) == StrawShape.TOP;
    }

    public static enum StrawShape implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private StrawShape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    record SaltReaction(Function<BlockState, BlockState> function, float chance) {
    }
}

