/*
 * Decompiled with CFR 0.152.
 */
package ihh.propertymodifier;

import ihh.propertymodifier.Config;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public final class PropertyModifierJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("propertymodifier", "propertymodifier");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        for (Item item : Config.REPAIR_MATERIALS.keySet()) {
            ItemStack left = new ItemStack((ItemLike)item);
            ItemStack out = left.m_41777_();
            int max = item.getMaxDamage(left);
            left.m_41721_(max - 1);
            out.m_41721_(max - max / 4);
            for (ItemStack repair : ((Ingredient)Config.REPAIR_MATERIALS.get(item).get()).m_43908_()) {
                IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(left, Collections.singletonList(repair), Collections.singletonList(out));
                registration.addRecipes(RecipeTypes.ANVIL, List.of(toolRepair));
            }
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        IRecipeManager manager = jeiRuntime.getRecipeManager();
        manager.hideRecipes(RecipeTypes.ANVIL, manager.createRecipeLookup(RecipeTypes.ANVIL).get().filter(e -> {
            ItemStack left = e.getLeftInputs().stream().filter(s -> Config.REPAIR_MATERIALS.containsKey(s.m_41720_())).findFirst().orElse(null);
            if (left != null) {
                for (ItemStack right : e.getRightInputs()) {
                    if (left.m_41720_().m_6832_(left, right) || right.m_150930_(Items.f_42690_) || right.m_150930_(left.m_41720_())) continue;
                    return true;
                }
            }
            return false;
        }).toList());
    }
}

