/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.network;

import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.ObscureAPIClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AnimationPlayMessage {
    private final int entity;
    private final byte animation;
    private final int tick;
    private final int duration;

    public AnimationPlayMessage(int entity, byte animation, int tick, int duration) {
        this.entity = entity;
        this.animation = animation;
        this.tick = tick;
        this.duration = duration;
    }

    public AnimationPlayMessage(FriendlyByteBuf buffer) {
        this.entity = buffer.readInt();
        this.animation = buffer.readByte();
        this.tick = buffer.readInt();
        this.duration = buffer.readInt();
    }

    public static void buffer(AnimationPlayMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entity);
        buffer.writeByte((int)message.animation);
        buffer.writeInt(message.tick);
        buffer.writeInt(message.duration);
    }

    public static void handler(AnimationPlayMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ObscureAPIClient.playAnimation(message.entity, message.animation, message.tick, message.duration)));
        context.get().setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ObscureAPI.addNetworkMessage(AnimationPlayMessage.class, AnimationPlayMessage::buffer, AnimationPlayMessage::new, AnimationPlayMessage::handler);
    }
}

