/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.blueprint;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.blueprint.BlueprintEntity;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.tableCloth.BlueprintOverlayShopContext;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.simibubi.create.content.trains.track.TrackPlacement;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class BlueprintOverlayRenderer {
    public static final IGuiOverlay OVERLAY = BlueprintOverlayRenderer::renderOverlay;
    static boolean active;
    static boolean empty;
    static boolean noOutput;
    static boolean lastSneakState;
    static BlueprintEntity.BlueprintSection lastTargetedSection;
    static BlueprintOverlayShopContext shopContext;
    static Map<ItemStack, ItemStack[]> cachedRenderedFilters;
    static List<Pair<ItemStack, Boolean>> ingredients;
    static List<ItemStack> results;
    static boolean resultCraftable;

    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        BlueprintEntity.BlueprintSection last = lastTargetedSection;
        lastTargetedSection = null;
        active = false;
        noOutput = false;
        shopContext = null;
        if (mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult mouseOver = mc.f_91077_;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        EntityHitResult entityRay = (EntityHitResult)mouseOver;
        Entity entity = entityRay.m_82443_();
        if (!(entity instanceof BlueprintEntity)) {
            return;
        }
        BlueprintEntity blueprintEntity = (BlueprintEntity)entity;
        BlueprintEntity.BlueprintSection sectionAt = blueprintEntity.getSectionAt(entityRay.m_82450_().m_82546_(blueprintEntity.m_20182_()));
        lastTargetedSection = last;
        active = true;
        boolean sneak = mc.f_91074_.m_6144_();
        if (sectionAt != lastTargetedSection || AnimationTickHolder.getTicks() % 10 == 0 || lastSneakState != sneak) {
            BlueprintOverlayRenderer.rebuild(sectionAt, sneak);
        }
        lastTargetedSection = sectionAt;
        lastSneakState = sneak;
    }

    public static void displayTrackRequirements(TrackPlacement.PlacementInfo info, ItemStack pavementItem) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer.prepareCustomOverlay();
        for (int tracks = info.requiredTracks; tracks > 0; tracks -= 64) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)new ItemStack((ItemLike)info.trackMaterial.getBlock(), Math.min(64, tracks)), (Object)info.hasRequiredTracks));
        }
        for (int pavement = info.requiredPavement; pavement > 0; pavement -= 64) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)pavementItem, (int)Math.min(64, pavement)), (Object)info.hasRequiredPavement));
        }
    }

    public static void displayChainRequirements(Item chainItem, int count, boolean fulfilled) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer.prepareCustomOverlay();
        for (int chains = count; chains > 0; chains -= 64) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)new ItemStack((ItemLike)chainItem, Math.min(64, chains)), (Object)fulfilled));
        }
    }

    public static void displayClothShop(TableClothBlockEntity dce, int alreadyPurchased, ShoppingListItem.ShoppingList list) {
        if (active) {
            return;
        }
        BlueprintOverlayRenderer.prepareCustomOverlay();
        noOutput = false;
        shopContext = new BlueprintOverlayShopContext(false, dce.getStockLevelForTrade(list), alreadyPurchased);
        ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)dce.getPaymentItem().m_255036_(dce.getPaymentAmount()), (Object)(!dce.getPaymentItem().m_41619_() && shopContext.stockLevel() > shopContext.purchases() ? 1 : 0)));
        for (BigItemStack entry : dce.requestData.encodedRequest.stacks()) {
            results.add(entry.stack.m_255036_(entry.count));
        }
    }

    public static void displayShoppingList(Couple<InventorySummary> bakedList) {
        if (active || bakedList == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlueprintOverlayRenderer.prepareCustomOverlay();
        noOutput = false;
        shopContext = new BlueprintOverlayShopContext(true, 1, 0);
        for (BigItemStack entry : ((InventorySummary)bakedList.getSecond()).getStacksByCount()) {
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)entry.stack.m_255036_(entry.count), (Object)BlueprintOverlayRenderer.canAfford((Player)mc.f_91074_, entry)));
        }
        for (BigItemStack entry : ((InventorySummary)bakedList.getFirst()).getStacksByCount()) {
            results.add(entry.stack.m_255036_(entry.count));
        }
    }

    private static boolean canAfford(Player player, BigItemStack entry) {
        int itemsPresent = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack item = player.m_150109_().m_8020_(i);
            if (item.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)entry.stack)) continue;
            itemsPresent += item.m_41613_();
        }
        return itemsPresent >= entry.count;
    }

    private static void prepareCustomOverlay() {
        active = true;
        empty = false;
        noOutput = true;
        ingredients.clear();
        results.clear();
        shopContext = null;
    }

    public static void rebuild(BlueprintEntity.BlueprintSection sectionAt, boolean sneak) {
        int i;
        cachedRenderedFilters.clear();
        ItemStackHandler items = sectionAt.getItems();
        boolean empty = true;
        for (int i2 = 0; i2 < 9; ++i2) {
            if (items.getStackInSlot(i2).m_41619_()) continue;
            empty = false;
            break;
        }
        BlueprintOverlayRenderer.empty = empty;
        results.clear();
        if (empty) {
            return;
        }
        boolean firstPass = true;
        boolean success = true;
        Minecraft mc = Minecraft.m_91087_();
        ItemStackHandler playerInv = new ItemStackHandler(mc.f_91074_.m_150109_().m_6643_());
        for (int i3 = 0; i3 < playerInv.getSlots(); ++i3) {
            playerInv.setStackInSlot(i3, mc.f_91074_.m_150109_().m_8020_(i3).m_41777_());
        }
        int amountCrafted = 0;
        Optional recipe = Optional.empty();
        HashMap<Integer, ItemStack> craftingGrid = new HashMap<Integer, ItemStack>();
        ingredients.clear();
        ItemStackHandler missingItems = new ItemStackHandler(64);
        ItemStackHandler availableItems = new ItemStackHandler(64);
        ArrayList<ItemStack> newlyAdded = new ArrayList<ItemStack>();
        ArrayList<ItemStack> newlyMissing = new ArrayList<ItemStack>();
        boolean invalid = false;
        do {
            craftingGrid.clear();
            newlyAdded.clear();
            newlyMissing.clear();
            block3: for (i = 0; i < 9; ++i) {
                FilterItemStack requestedItem = FilterItemStack.of(items.getStackInSlot(i));
                if (requestedItem.isEmpty()) {
                    craftingGrid.put(i, ItemStack.f_41583_);
                    continue;
                }
                for (int slot = 0; slot < playerInv.getSlots(); ++slot) {
                    if (!requestedItem.test((Level)mc.f_91073_, playerInv.getStackInSlot(slot))) continue;
                    ItemStack currentItem = playerInv.extractItem(slot, 1, false);
                    craftingGrid.put(i, currentItem);
                    newlyAdded.add(currentItem);
                    continue block3;
                }
                success = false;
                newlyMissing.add(requestedItem.item());
            }
            if (success) {
                ItemStack resultFromRecipe;
                BlueprintEntity.BlueprintCraftingInventory craftingInventory = new BlueprintEntity.BlueprintCraftingInventory(craftingGrid);
                if (!recipe.isPresent()) {
                    recipe = mc.f_91073_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, (Level)mc.f_91073_);
                }
                if ((resultFromRecipe = recipe.filter(arg_0 -> BlueprintOverlayRenderer.lambda$rebuild$0((CraftingContainer)craftingInventory, mc, arg_0)).map(arg_0 -> BlueprintOverlayRenderer.lambda$rebuild$1((CraftingContainer)craftingInventory, mc, arg_0)).orElse(ItemStack.f_41583_)).m_41619_()) {
                    if (!recipe.isPresent()) {
                        invalid = true;
                    }
                    success = false;
                } else if (resultFromRecipe.m_41613_() + amountCrafted > 64) {
                    success = false;
                } else {
                    amountCrafted += resultFromRecipe.m_41613_();
                    if (results.isEmpty()) {
                        results.add(resultFromRecipe.m_41777_());
                    } else {
                        results.get(0).m_41769_(resultFromRecipe.m_41613_());
                    }
                    resultCraftable = true;
                    firstPass = false;
                }
            }
            if (success || firstPass) {
                newlyAdded.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)availableItems, (ItemStack)s, (boolean)false));
                newlyMissing.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)missingItems, (ItemStack)s, (boolean)false));
            }
            if (success) continue;
            if (!firstPass) break;
            results.clear();
            if (!invalid) {
                results.add(items.getStackInSlot(9));
            }
            resultCraftable = false;
            break;
        } while (sneak && success);
        for (i = 0; i < 9; ++i) {
            ItemStack available = availableItems.getStackInSlot(i);
            if (available.m_41619_()) continue;
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)available, (Object)true));
        }
        for (i = 0; i < 9; ++i) {
            ItemStack missing = missingItems.getStackInSlot(i);
            if (missing.m_41619_()) continue;
            ingredients.add((Pair<ItemStack, Boolean>)Pair.of((Object)missing, (Object)false));
        }
    }

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91080_ != null) {
            return;
        }
        if (!active || empty) {
            return;
        }
        boolean invalidShop = shopContext != null && (ingredients.isEmpty() || ((ItemStack)ingredients.get(0).getFirst()).m_41619_() || shopContext.stockLevel() == 0);
        int w = 21 * ingredients.size();
        if (!noOutput) {
            w += 21 * results.size();
            w += 30;
        }
        int x = (width - w) / 2;
        int y = height - 100;
        if (shopContext != null) {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)(x - 2), (int)(y + 1), (int)(w + 4), (int)19, (int)0, (int)0x55000000, (int)0x55000000, (int)0, (int)0);
            AllGuiTextures.TRADE_OVERLAY.render(graphics, width / 2 - 48, y - 19);
            if (shopContext.purchases() > 0) {
                graphics.m_280480_(AllItems.SHOPPING_LIST.asStack(), width / 2 + 20, y - 20);
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)("x" + shopContext.purchases())), width / 2 + 20 + 16, y - 20 + 4, -1118482, true);
            }
        }
        for (Pair<ItemStack, Boolean> pair : ingredients) {
            RenderSystem.enableBlend();
            ((Boolean)pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(graphics, x, y);
            ItemStack itemStack = (ItemStack)pair.getFirst();
            String count = shopContext != null && !shopContext.checkout() || (Boolean)pair.getSecond() != false ? null : ChatFormatting.GOLD.toString() + itemStack.m_41613_();
            BlueprintOverlayRenderer.drawItemStack(graphics, mc, x, y, itemStack, count);
            x += 21;
        }
        if (noOutput) {
            return;
        }
        x += 5;
        RenderSystem.enableBlend();
        if (invalidShop) {
            AllGuiTextures.HOTSLOT_ARROW_BAD.render(graphics, x, y + 4);
        } else {
            AllGuiTextures.HOTSLOT_ARROW.render(graphics, x, y + 4);
        }
        x += 25;
        if (results.isEmpty()) {
            AllGuiTextures.HOTSLOT.render(graphics, x, y);
            GuiGameElement.of((ItemLike)Items.f_42127_).at((float)(x + 3), (float)(y + 3)).render(graphics);
        } else {
            for (ItemStack result : results) {
                AllGuiTextures slot;
                AllGuiTextures allGuiTextures = slot = resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT;
                if (!invalidShop && shopContext != null && shopContext.stockLevel() > shopContext.purchases()) {
                    slot = AllGuiTextures.HOTSLOT_ACTIVE;
                }
                slot.render(graphics, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
                BlueprintOverlayRenderer.drawItemStack(graphics, mc, x, y, result, null);
                x += 21;
            }
        }
        if (shopContext != null && !shopContext.checkout()) {
            int cycle = 0;
            for (boolean count : Iterate.trueAndFalse) {
                for (int i = 0; i < results.size(); ++i) {
                    ItemStack result = results.get(i);
                    List tooltipLines = result.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.f_256752_);
                    if (tooltipLines.size() <= 1) continue;
                    if (count) {
                        ++cycle;
                        continue;
                    }
                    if (gui.m_93079_() / 40 % cycle != i) continue;
                    graphics.m_280666_(gui.m_93082_(), tooltipLines, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
                }
            }
        }
        RenderSystem.disableBlend();
    }

    public static void drawItemStack(GuiGraphics graphics, Minecraft mc, int x, int y, ItemStack itemStack, String count) {
        if (itemStack.m_41720_() instanceof FilterItem) {
            int step = AnimationTickHolder.getTicks((LevelAccessor)mc.f_91073_) / 10;
            ItemStack[] itemsMatchingFilter = BlueprintOverlayRenderer.getItemsMatchingFilter(itemStack);
            if (itemsMatchingFilter.length > 0) {
                itemStack = itemsMatchingFilter[step % itemsMatchingFilter.length];
            }
        }
        GuiGameElement.of((ItemStack)itemStack).at((float)(x + 3), (float)(y + 3)).render(graphics);
        graphics.m_280302_(mc.f_91062_, itemStack, x + 3, y + 3, count);
    }

    private static ItemStack[] getItemsMatchingFilter(ItemStack filter) {
        return cachedRenderedFilters.computeIfAbsent(filter, itemStack -> {
            CompoundTag tag = itemStack.m_41784_();
            if (AllItems.FILTER.isIn(itemStack) && !tag.m_128471_("Blacklist")) {
                ItemStackHandler filterItems = FilterItem.getFilterItems(itemStack);
                return (ItemStack[])ItemHelper.getNonEmptyStacks(filterItems).toArray(ItemStack[]::new);
            }
            if (AllItems.ATTRIBUTE_FILTER.isIn(itemStack)) {
                ItemAttribute fromNBT;
                AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[tag.m_128451_("WhitelistMode")];
                ListTag attributes = tag.m_128437_("MatchedAttributes", 10);
                if (whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ && attributes.size() == 1 && (fromNBT = ItemAttribute.loadStatic((CompoundTag)attributes.get(0))) instanceof InTagAttribute) {
                    ITag taggedItems;
                    InTagAttribute inTag = (InTagAttribute)fromNBT;
                    ITagManager tagManager = ForgeRegistries.ITEMS.tags();
                    if (tagManager.isKnownTagName(inTag.tag) && !(taggedItems = tagManager.getTag(inTag.tag)).isEmpty()) {
                        ItemStack[] stacks = new ItemStack[taggedItems.size()];
                        int i = 0;
                        for (Item item : taggedItems) {
                            stacks[i] = new ItemStack((ItemLike)item);
                            ++i;
                        }
                        return stacks;
                    }
                }
            }
            return new ItemStack[0];
        });
    }

    private static /* synthetic */ ItemStack lambda$rebuild$1(CraftingContainer craftingInventory, Minecraft mc, CraftingRecipe r) {
        return r.m_5874_((Container)craftingInventory, mc.f_91073_.m_9598_());
    }

    private static /* synthetic */ boolean lambda$rebuild$0(CraftingContainer craftingInventory, Minecraft mc, CraftingRecipe r) {
        return r.m_5818_((Container)craftingInventory, (Level)mc.f_91073_);
    }

    static {
        cachedRenderedFilters = new IdentityHashMap<ItemStack, ItemStack[]>();
        ingredients = new ArrayList<Pair<ItemStack, Boolean>>();
        results = new ArrayList<ItemStack>();
        resultCraftable = false;
    }
}

