/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.incontrol.rules.PhaseRule;
import mcjty.incontrol.rules.RulesManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DataStorage
extends SavedData {
    private static final String NAME = "InControlData";
    private Boolean isDay = null;
    private int daycounter = 0;
    private final Set<String> phases = new HashSet<String>();
    private final Map<String, Integer> numbers = new HashMap<String, Integer>();
    private int checkCounter = 0;

    public DataStorage() {
    }

    public DataStorage(CompoundTag tag) {
        this.daycounter = tag.m_128451_("daycounter");
        this.isDay = tag.m_128441_("isday") ? Boolean.valueOf(tag.m_128471_("isday")) : null;
        ListTag phasesTag = tag.m_128437_("phases", 8);
        for (int i = 0; i < phasesTag.size(); ++i) {
            this.phases.add(phasesTag.m_128778_(i));
        }
        CompoundTag numbersTag = tag.m_128469_("numbers");
        for (String key : numbersTag.m_128431_()) {
            this.numbers.put(key, numbersTag.m_128451_(key));
        }
    }

    @Nonnull
    public static DataStorage getData(LevelAccessor world) {
        if (world.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        MinecraftServer server = world.m_7654_();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        DimensionDataStorage storage = overworld.m_8895_();
        return (DataStorage)storage.m_164861_(DataStorage::new, DataStorage::new, NAME);
    }

    public int getDaycounter() {
        return this.daycounter;
    }

    public void setDaycounter(int daycounter) {
        this.daycounter = daycounter;
        this.m_77762_();
    }

    public void tick(Level world) {
        this.tickTime(world);
        --this.checkCounter;
        if (this.checkCounter <= 0) {
            this.checkCounter = 10;
            this.tickPhases(world);
        }
    }

    private void tickTime(Level world) {
        boolean day;
        long time = world.m_46468_() % 24000L;
        boolean bl = day = time >= 0L && time < 12000L;
        if (this.isDay == null) {
            this.isDay = day;
            this.m_77762_();
        } else if (day != this.isDay) {
            if (day) {
                ++this.daycounter;
            }
            this.isDay = day;
            this.m_77762_();
        }
    }

    public Map<String, Integer> getNumbers() {
        return this.numbers;
    }

    public void setNumber(String name, int value) {
        this.numbers.put(name, value);
        this.m_77762_();
    }

    public int getNumber(String name) {
        return this.numbers.getOrDefault(name, 0);
    }

    public Set<String> getPhases() {
        return this.phases;
    }

    public void setPhase(String phase, boolean value) {
        if (value) {
            if (this.phases.add(phase)) {
                RulesManager.onPhaseChange();
                this.m_77762_();
            }
        } else if (this.phases.remove(phase)) {
            RulesManager.onPhaseChange();
            this.m_77762_();
        }
    }

    public void togglePhase(String phase) {
        if (this.phases.contains(phase)) {
            this.phases.remove(phase);
        } else {
            this.phases.add(phase);
        }
        RulesManager.onPhaseChange();
        this.m_77762_();
    }

    private void tickPhases(Level world) {
        boolean dirty = false;
        for (PhaseRule rule : RulesManager.phaseRules) {
            if (rule.match((LevelAccessor)world)) {
                if (!this.phases.add(rule.getName())) continue;
                dirty = true;
                continue;
            }
            if (!this.phases.remove(rule.getName())) continue;
            dirty = true;
        }
        if (dirty) {
            RulesManager.onPhaseChange();
            this.m_77762_();
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("daycounter", this.daycounter);
        if (this.isDay != null) {
            tag.m_128379_("isday", this.isDay.booleanValue());
        }
        ListTag phasesTag = new ListTag();
        for (String phase : this.phases) {
            phasesTag.add((Object)StringTag.m_129297_((String)phase));
        }
        tag.m_128365_("phases", (Tag)phasesTag);
        CompoundTag numbersTag = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.numbers.entrySet()) {
            numbersTag.m_128405_(entry.getKey(), entry.getValue().intValue());
        }
        tag.m_128365_("numbers", (Tag)numbersTag);
        return tag;
    }
}

