/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.utils;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class ShapeUtils {
    public static Map<Direction.Axis, VoxelShape> allAxis(VoxelShape facingY) {
        EnumMap<Direction.Axis, VoxelShape> map = new EnumMap<Direction.Axis, VoxelShape>(Direction.Axis.class);
        for (Direction.Axis axis : Direction.Axis.values()) {
            Vec3 dir = ShapeUtils.getDirectionRotationVec(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
            map.put(axis, ShapeUtils.rotatedCopy(facingY, dir));
        }
        return map;
    }

    public static Map<Direction, VoxelShape> allDirections(VoxelShape facingUp) {
        EnumMap<Direction, VoxelShape> map = new EnumMap<Direction, VoxelShape>(Direction.class);
        for (Direction dir : Direction.values()) {
            map.put(dir, ShapeUtils.rotatedCopy(facingUp, ShapeUtils.getDirectionRotationVec(dir)));
        }
        return map;
    }

    public static VoxelShape rotatedCopy(VoxelShape shape, Vec3 rotation) {
        if (rotation.equals((Object)Vec3.f_82478_)) {
            return shape;
        }
        MutableObject result = new MutableObject((Object)Shapes.m_83040_());
        Vec3 center = new Vec3(8.0, 8.0, 8.0);
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            Vec3 v1 = new Vec3(x1, y1, z1).m_82490_(16.0).m_82546_(center);
            Vec3 v2 = new Vec3(x2, y2, z2).m_82490_(16.0).m_82546_(center);
            v1 = ShapeUtils.rotateVec(v1, (float)rotation.f_82479_, Direction.Axis.X);
            v1 = ShapeUtils.rotateVec(v1, (float)rotation.f_82480_, Direction.Axis.Y);
            v1 = ShapeUtils.rotateVec(v1, (float)rotation.f_82481_, Direction.Axis.Z).m_82549_(center);
            v2 = ShapeUtils.rotateVec(v2, (float)rotation.f_82479_, Direction.Axis.X);
            v2 = ShapeUtils.rotateVec(v2, (float)rotation.f_82480_, Direction.Axis.Y);
            v2 = ShapeUtils.rotateVec(v2, (float)rotation.f_82481_, Direction.Axis.Z).m_82549_(center);
            VoxelShape rotated = Block.m_49796_((double)Math.min(v1.f_82479_, v2.f_82479_), (double)Math.min(v1.f_82480_, v2.f_82480_), (double)Math.min(v1.f_82481_, v2.f_82481_), (double)Math.max(v1.f_82479_, v2.f_82479_), (double)Math.max(v1.f_82480_, v2.f_82480_), (double)Math.max(v1.f_82481_, v2.f_82481_));
            result.setValue((Object)Shapes.m_83110_((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
        });
        return (VoxelShape)result.getValue();
    }

    public static Vec3 rotateVec(Vec3 vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.f_82478_) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Mth.m_14031_((float)angle);
        double cos = Mth.m_14089_((float)angle);
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        if (axis == Direction.Axis.X) {
            return new Vec3(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static double length(VoxelShape shape, Direction.Axis axis) {
        return shape.m_83281_() ? 0.0 : shape.m_83297_(axis) - shape.m_83288_(axis);
    }

    private static Vec3 getDirectionRotationVec(Direction direction) {
        return direction == Direction.UP ? Vec3.f_82478_ : new Vec3(Direction.Plane.VERTICAL.test(direction) ? 180.0 : 90.0, (double)(-((float)(Math.max(direction.m_122416_(), 0) & 3) * 90.0f)), 0.0);
    }
}

