/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.integrations.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.artienia.rubinated_nether.content.RNBlocks;
import net.artienia.rubinated_nether.content.block.freezer.FreezerBlock;
import net.artienia.rubinated_nether.content.recipe.freezing.FreezingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FreezingCategory
implements IRecipeCategory<FreezingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("rubinated_nether", "freezing");
    public static final ResourceLocation TEXTURE = new ResourceLocation("rubinated_nether", "textures/gui/freezer_gui.png");
    public static final RecipeType<FreezingRecipe> FREEZING_RECIPE_TYPE = new RecipeType(UID, FreezingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable fuelIndicator;
    private final IDrawableAnimated animatedProgressArrow;

    public FreezingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 55, 16, 82, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)((FreezerBlock)((Object)RNBlocks.FREEZER.get())).m_5456_()));
        this.fuelIndicator = helper.createDrawable(TEXTURE, 176, 0, 14, 13);
        this.animatedProgressArrow = helper.createAnimatedDrawable(helper.createDrawable(TEXTURE, 176, 14, 23, 16), 100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<FreezingRecipe> getRecipeType() {
        return FREEZING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.rubinated_nether.jei.freezer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FreezingRecipe freezingRecipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)freezingRecipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 19).addItemStack(freezingRecipe.getResult());
    }

    public void draw(FreezingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedProgressArrow.draw(guiGraphics, 24, 18);
        this.fuelIndicator.draw(guiGraphics, 1, 20);
        this.drawExperience(recipe, guiGraphics, 1, this.background);
        this.drawCookingTime(guiGraphics, 45, recipe.m_43753_(), this.background);
    }

    protected void drawExperience(FreezingRecipe recipe, GuiGraphics guiGraphics, int y, IDrawable background) {
        float experience = recipe.m_43750_();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            guiGraphics.m_280614_(fontRenderer, (Component)experienceString, background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookingTime(GuiGraphics guiGraphics, int y, int time, IDrawable background) {
        if (time > 0) {
            int cookTimeSeconds = time / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(fontRenderer, (Component)timeString, background.getWidth() - stringWidth, y, -8355712, false);
        }
    }
}

