/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.integrations.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.artienia.rubinated_nether.content.RNBlocks;
import net.artienia.rubinated_nether.content.block.freezer.FreezerBlock;
import net.artienia.rubinated_nether.integrations.viewers.FuelRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class FreezerFuelCategory
implements IRecipeCategory<FuelRecipe> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("rubinated_nether", "textures/gui/freezer_gui.png");
    public static final RecipeType<FuelRecipe> RECIPE_TYPE = RecipeType.create((String)"rubinated_nether", (String)"fuel", FuelRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedFuelIndicator;

    public FreezerFuelCategory(IGuiHelper helper) {
        this(helper, List.of(((FreezerBlock)((Object)RNBlocks.FREEZER.get())).m_49954_().getString()));
    }

    public FreezerFuelCategory(final IGuiHelper helper, List<String> craftingStations) {
        String longestString = craftingStations.stream().max(Comparator.comparingInt(String::length)).get();
        MutableComponent longestStationName = Component.m_237113_((String)longestString);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Component maxBurnTimeText = FreezerFuelCategory.createBurnTimeText(10000, (Component)longestStationName);
        int maxStringWidth = fontRenderer.m_92895_(maxBurnTimeText.getString());
        int backgroundHeight = 34;
        int textPadding = 20;
        this.background = helper.drawableBuilder(this.getTexture(), 55, 36, 18, backgroundHeight).addPadding(0, 0, 0, textPadding + maxStringWidth).build();
        this.icon = helper.createDrawable(this.getTexture(), 176, 0, 14, 13);
        this.cachedFuelIndicator = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer burnTime) {
                return helper.drawableBuilder(FreezerFuelCategory.this.getTexture(), 176, 0, 14, 13).buildAnimated(burnTime.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.rubinated_nether.jei.fuel");
    }

    public RecipeType<FuelRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addItemStacks(recipe.getInput());
    }

    public void draw(FuelRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int burnTime = recipe.getBurnTime();
        IDrawableAnimated fuelIndicator = (IDrawableAnimated)this.cachedFuelIndicator.getUnchecked((Object)burnTime);
        fuelIndicator.draw(guiGraphics, 1, 0);
        Font font = Minecraft.m_91087_().f_91062_;
        Component burnTimeText = FreezerFuelCategory.createBurnTimeText(recipe.getBurnTime(), (Component)recipe.getUsage().m_49954_());
        int stringWidth = font.m_92852_((FormattedText)burnTimeText);
        guiGraphics.m_280614_(font, burnTimeText, this.background.getWidth() - stringWidth, 14, -8355712, false);
    }

    private static Component createBurnTimeText(int burnTime, Component usage) {
        return Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{burnTime / 20}).m_130946_(" (").m_7220_(usage).m_130946_(")");
    }
}

