/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.integrations.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.artienia.rubinated_nether.content.recipe.freezing.FreezingRecipe;
import net.artienia.rubinated_nether.integrations.emi.EMIModPlugin;
import net.artienia.rubinated_nether.integrations.emi.EMIStuff;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class FreezingEMIRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient input;
    private final EmiStack output;
    private final FreezingRecipe recipe;

    public FreezingEMIRecipe(FreezingRecipe recipe) {
        this.recipe = recipe;
        this.id = recipe.m_6423_();
        this.input = EmiIngredient.of((Ingredient)((Ingredient)recipe.m_7527_().get(0)));
        this.output = EmiStack.of((ItemStack)recipe.getResult());
    }

    public void addWidgets(WidgetHolder widgets) {
        int ticks = this.recipe.m_43753_();
        widgets.addFillingArrow(24, 5, ticks * 50).tooltip(List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237110_((String)"emi.cooking.time", (Object[])new Object[]{ticks / 20}).m_7532_())));
        widgets.addTexture(EMIStuff.FULL_FREEZE, 1, 24);
        widgets.addText((Component)Component.m_237110_((String)"emi.cooking.experience", (Object[])new Object[]{Float.valueOf(this.recipe.m_43750_())}), 26, 28, -1, true);
        widgets.addSlot(this.input, 0, 4);
        widgets.addSlot((EmiIngredient)this.output, 56, 0).large(true).recipeContext((EmiRecipe)this);
    }

    public EmiRecipeCategory getCategory() {
        return EMIModPlugin.FREEZING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return 38;
    }
}

