/*
 * Decompiled with CFR 0.152.
 */
package net.artienia.rubinated_nether.integrations.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.artienia.rubinated_nether.RubinatedNether;
import net.artienia.rubinated_nether.integrations.emi.EMIModPlugin;
import net.artienia.rubinated_nether.integrations.emi.EMIStuff;
import net.artienia.rubinated_nether.integrations.viewers.FuelRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FreezerFuelEMIRecipe
implements EmiRecipe {
    private static final String ID_FORMAT = "freezer_fuel/%s/%s";
    private final EmiIngredient stack;
    private final int time;
    private final ResourceLocation id;

    public FreezerFuelEMIRecipe(FuelRecipe recipe) {
        this.stack = EmiIngredient.of(recipe.getInput().stream().map(EmiStack::of).toList());
        this.time = recipe.getBurnTime();
        ResourceLocation loc = BuiltInRegistries.f_257033_.m_7981_((Object)recipe.getInput().get(0).m_41720_());
        this.id = RubinatedNether.id(ID_FORMAT.formatted(loc.m_135827_(), loc.m_135815_()));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EMIStuff.EMPTY_FREEZE, 1, 1);
        widgets.addAnimatedTexture(EMIStuff.FULL_FREEZE, 1, 1, 1000 * this.time / 20, false, true, true);
        widgets.addSlot(this.stack, 18, 0).recipeContext((EmiRecipe)this);
        widgets.addText((Component)Component.m_237110_((String)"gui.rubinated_nether.emi.freezes", (Object[])new Object[]{EMIStuff.TEXT_FORMAT.format((float)this.time / 200.0f)}), 38, 5, -1, true);
    }

    public EmiRecipeCategory getCategory() {
        return EMIModPlugin.FREEZER_FUEL;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.stack);
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 18;
    }
}

